/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.item;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.item.TextViewField;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;

public class TextViewItem
extends ViewItem {
    private TextViewField text;

    public TextViewItem() {
        this.createTextView();
        this.baseView.setViewItem((Node)this.text);
        this.addListener();
    }

    protected void createTextView() {
        this.text = new TextViewField();
    }

    protected void addListener() {
        this.text.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> arg0, String arg1, String arg2) {
                Event event = new Event(EventType.Modify);
                event.text = arg2;
                TextViewItem.this.sendEvent(event);
            }
        });
    }

    public TextField getTextField() {
        return this.text;
    }

    public void setText(String t) {
        this.text.setText(t);
        this.baseView.layout();
    }

    public String getText() {
        return this.text.getText();
    }

    public void setMaxLen(int maxLen) {
        this.text.setMaxLen(maxLen);
    }

    public void setMatchStr(String matchStr) {
        this.text.setMatchStr(matchStr);
    }

    @Override
    public String toString() {
        return this.text.getText();
    }

    public void setTextWidth(double width) {
        this.text.setPrefWidth(width);
    }
}

