/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.create;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.ui.devicetemplate.controller.DisplaySizeViewController;
import org.tizen.emulator.manager.ui.devicetemplate.controller.ResolutionViewController;
import org.tizen.emulator.manager.ui.devicetemplate.controller.SkinShapeViewController;
import org.tizen.emulator.manager.ui.devicetemplate.controller.SkinViewController;
import org.tizen.emulator.manager.ui.devicetemplate.controller.TemplateCheckBoxController;
import org.tizen.emulator.manager.ui.devicetemplate.controller.TemplateNameViewController;
import org.tizen.emulator.manager.ui.tabview.controller.CheckLabelViewController;
import org.tizen.emulator.manager.ui.tabview.controller.TextViewController;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.item.ComboViewItem;
import org.tizen.emulator.manager.ui.tabview.item.DisplayLabelViewItem;
import org.tizen.emulator.manager.ui.tabview.item.FileViewItem;
import org.tizen.emulator.manager.ui.tabview.item.LabelViewItem;
import org.tizen.emulator.manager.ui.tabview.item.NetProxyViewItem;
import org.tizen.emulator.manager.ui.tabview.item.NetTCPIPViewItem;
import org.tizen.emulator.manager.ui.tabview.item.NetTapDeviceViewItem;
import org.tizen.emulator.manager.ui.tabview.item.TextViewItem;
import org.tizen.emulator.manager.ui.tabview.item.ToggleButtonViewItem;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;
import org.tizen.emulator.manager.ui.template.Template;
import org.tizen.emulator.manager.ui.template.item.Group;
import org.tizen.emulator.manager.ui.template.item.Item;

public class DeviceTemplateViewHelper {
    private static final String DIALOG_XML_FILE_PREFIX = "devicetemplate-dialog-";
    public static final String DIALOG_XML_FILE_MOBILE = "devicetemplate-dialog-mobile.xml";
    public static final String DIALOG_XML_FILE_WEABLE = "devicetemplate-dialog-wearable.xml";
    public static final String DIALOG_XML_FILE_TV = "devicetemplate-dialog-tv.xml";

    public static List<Item> getDeviceTemplateItemList(Template template) {
        if (template == null) {
            return null;
        }
        List<Group> groupList = template.getGroupItems();
        ArrayList<Item> items = new ArrayList<Item>();
        for (Group group : groupList) {
            items.addAll(group.getItems());
        }
        return items;
    }

    public static String getTemplatePath(String profile) {
        return FilePathResources.getToolEmulatorDataPath() + File.separator + DeviceTemplateViewHelper.getTemplateFileName(profile);
    }

    private static String getTemplateFileName(String profile) {
        String fileName = "";
        fileName = profile.equals("tv") ? fileName + DIALOG_XML_FILE_TV : (profile.equals("wearable") ? fileName + DIALOG_XML_FILE_WEABLE : fileName + DIALOG_XML_FILE_MOBILE);
        return fileName;
    }

    public static List<ViewItemController> getViewItemList(List<Item> list) {
        ArrayList<ViewItemController> itemList = new ArrayList<ViewItemController>();
        for (Item i : list) {
            ViewItemController item = DeviceTemplateViewHelper.findViewItem(i);
            if (item == null) continue;
            item.makeViewItem();
            itemList.add(item);
            if (i.getSubItems().isEmpty()) continue;
            DeviceTemplateViewHelper.setSubViewItemList(item, i.getSubItems());
        }
        return itemList;
    }

    private static ViewItemController findViewItem(Item item) {
        ViewItemController viewItem = null;
        String name = item.getName();
        if (name.equals("name")) {
            viewItem = new TemplateNameViewController(item);
        } else if (name.equals("resolution")) {
            viewItem = new ResolutionViewController(item);
        } else if (name.equals("size")) {
            viewItem = new DisplaySizeViewController(item);
        } else if (name.equals("skin")) {
            viewItem = new SkinViewController(item);
        } else if (name.equals("skinShape")) {
            viewItem = new SkinShapeViewController(item);
        } else if (name.equals("sensor")) {
            viewItem = DeviceTemplateViewHelper.createCheckLabelViewController(item);
        } else if (name.equals("connectivity")) {
            viewItem = DeviceTemplateViewHelper.createCheckLabelViewController(item);
        } else if (name.equals("camera")) {
            viewItem = DeviceTemplateViewHelper.createCheckLabelViewController(item);
        }
        return viewItem;
    }

    private static CheckLabelViewController createCheckLabelViewController(Item checkItem) {
        CheckLabelViewController c = new CheckLabelViewController(checkItem);
        for (Item item : checkItem.getSubItems()) {
            if (item.isExperimental() || !item.isSupportOS()) continue;
            TemplateCheckBoxController subViewItem = new TemplateCheckBoxController(item, c);
            ((ViewItemController)subViewItem).makeViewItem();
            c.addSubViewItem(subViewItem);
        }
        return c;
    }

    public static void setSubViewItemList(ViewItemController parent, List<Item> list) {
        for (Item i : list) {
            ViewItemController item = DeviceTemplateViewHelper.findSubViewItem(parent, i);
            item.setViewItem(DeviceTemplateViewHelper.findViewWidget(item));
            parent.addSubViewItem(item);
        }
    }

    private static ViewItem findViewWidget(ViewItemController item) {
        ViewItem widget = null;
        String name = item.getName();
        if (name.equals("proxy")) {
            widget = new NetProxyViewItem();
        } else if (name.equals("netTapDevice")) {
            widget = new NetTapDeviceViewItem();
        } else if (name.equals("netIpInfo")) {
            widget = new NetTCPIPViewItem();
        } else if (name.equals("display")) {
            widget = new DisplayLabelViewItem();
        }
        if (widget == null) {
            String type = item.getType();
            if (type.equals("textInput") || type.equals("text")) {
                widget = new TextViewItem();
            } else if (type.equals("combo")) {
                widget = new ComboViewItem();
            } else if (type.equals("toggle")) {
                widget = new ToggleButtonViewItem();
            } else if (type.equals("label")) {
                widget = new LabelViewItem();
            } else if (!type.equals("checkbox") && type.equals("file")) {
                widget = new FileViewItem();
            }
        }
        if (widget == null) {
            widget = new LabelViewItem();
        }
        return widget;
    }

    private static ViewItemController findSubViewItem(ViewItemController parent, Item item) {
        return new TextViewController(item, parent);
    }
}

