/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.vms;

import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import org.tizen.emulator.manager.ui.control.TizenCheckBox;
import org.tizen.emulator.manager.ui.item.VMItem;

class VMCheckBoxCell
extends TableCell<VMItem, Boolean> {
    TizenCheckBox checkBox = new TizenCheckBox();
    EventHandler<MouseEvent> handler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
                if (event.isShiftDown()) {
                    return;
                }
                VMCheckBoxCell.this.toggleSelection();
                event.consume();
            } else if (event.getEventType() == MouseEvent.MOUSE_RELEASED) {
                event.consume();
            }
        }
    };

    VMCheckBoxCell() {
    }

    void toggleSelection() {
        int rowIndex = this.getTableRow().getIndex();
        if (this.checkBox.isSelected()) {
            this.getTableView().getSelectionModel().clearSelection(rowIndex);
        } else if (this.getTableView().getSelectionModel().getSelectedIndices().size() == 0) {
            this.getTableView().getSelectionModel().clearAndSelect(rowIndex);
        } else {
            this.getTableView().getSelectionModel().select(rowIndex);
        }
    }

    protected void updateItem(Boolean item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (this.isEmpty()) {
            this.setText(null);
            this.setTooltip(null);
            this.setGraphic(null);
            return;
        }
        this.checkBox.setSelected(item);
        this.checkBox.setSpacing(0.0);
        this.setGraphic((Node)this.checkBox.getPane());
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, this.handler);
        this.addEventFilter(MouseEvent.MOUSE_RELEASED, this.handler);
    }

    static Callback<TableColumn<VMItem, Boolean>, TableCell<VMItem, Boolean>> extractor() {
        return new Callback<TableColumn<VMItem, Boolean>, TableCell<VMItem, Boolean>>(){

            public TableCell<VMItem, Boolean> call(TableColumn<VMItem, Boolean> param) {
                return new VMCheckBoxCell();
            }
        };
    }
}

