/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.item;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.control.Button;
import javafx.util.Callback;
import org.tizen.emulator.manager.ui.controller.create.VMDialogData;
import org.tizen.emulator.manager.ui.controller.create.VMDialogPage;
import org.tizen.emulator.manager.ui.dialog.ButtonType;
import org.tizen.emulator.manager.ui.dialog.Dialog;
import org.tizen.emulator.manager.ui.item.VMItem;
import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.ui.tabview.TabViewer;
import org.tizen.emulator.manager.vms.VMPropertyValue;

class ModifyDialog {
    private Dialog<VMPropertyValue> dialog;
    private Button okButton;
    private VMDialogPage propertyPage;
    private VMItem selectedItem;
    private VMDialogData data;
    private final BooleanProperty isInvalid = new SimpleBooleanProperty(false){

        protected void invalidated() {
            ModifyDialog.this.okButton.setDisable(ModifyDialog.this.isInvalid.get());
        }
    };

    public ModifyDialog(VMItem item) {
        this.selectedItem = item;
        this.dialog = new Dialog();
        this.dialog.setResizable(true);
        this.dialog.setTitle("Emulator Configuration");
        this.dialog.getDialogPane().addButonType(ButtonType.CONFIRM);
        this.dialog.getDialogPane().addButonType(ButtonType.CANCEL);
        this.dialog.setMinSize(500.0, 450.0);
        this.okButton = this.dialog.getDialogPane().getButton(ButtonType.CONFIRM);
        this.propertyPage = new TabViewer();
        this.dialog.getDialogPane().setContent(this.propertyPage.getNode());
        this.dialog.setResultConverter(new Callback<ButtonType, VMPropertyValue>(){

            public VMPropertyValue call(ButtonType param) {
                if (param == ButtonType.CANCEL) {
                    return null;
                }
                ModifyDialog.this.propertyPage.setData(ModifyDialog.this.data);
                return ModifyDialog.this.data.getVmValue();
            }
        });
    }

    public VMPropertyValue open() {
        if (this.selectedItem != null) {
            this.data = this.selectedItem.getDialogData();
            this.data.setMode(MODE.MODIFY);
            this.propertyPage.onPageShow(this.data, (SimpleBooleanProperty)this.isInvalid);
            return this.dialog.showAndWait();
        }
        return null;
    }
}

