/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.item;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javafx.application.Platform;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.tizen.emulator.manager.concurrent.SimpleExecutor;
import org.tizen.emulator.manager.concurrent.TaskCompletionListener;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.ui.Main;
import org.tizen.emulator.manager.ui.Messages;
import org.tizen.emulator.manager.ui.dialog.ButtonBar;
import org.tizen.emulator.manager.ui.dialog.ButtonType;
import org.tizen.emulator.manager.ui.dialog.CheckReturn;
import org.tizen.emulator.manager.ui.dialog.MessageBox;
import org.tizen.emulator.manager.ui.item.VMItem;
import org.tizen.emulator.manager.vms.Creator;
import org.tizen.emulator.manager.vms.VMPropertyValue;
import org.tizen.emulator.manager.vms.exception.VMLauncherException;
import org.tizen.emulator.manager.vms.exception.VMWorkerException;

public class VMEventHandler {
    private static SimpleBooleanProperty isVisible = new SimpleBooleanProperty(false);
    private static TaskCompletionListener<String> completionListener = new TaskCompletionListener<String>(){

        @Override
        public void completed(final String result) {
            EMLogger.getLogger().fine("Stop progress indicator");
            if (!result.isEmpty()) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MessageBox.error("Error", result);
                    }
                });
            }
            VMEventHandler.setProgress(false);
        }
    };

    public static SimpleBooleanProperty getIsVisible() {
        return isVisible;
    }

    public static void launch(final VMItem item) {
        assert (item != null);
        EMLogger.getLogger().fine("Start progress indicator for launch: " + item.getName());
        VMEventHandler.setProgress(true);
        SimpleExecutor.asynExecute(new Callable<String>(){
            private String returnMsg;

            @Override
            public String call() throws Exception {
                this.returnMsg = "";
                try {
                    item.launch();
                }
                catch (VMLauncherException e) {
                    this.returnMsg = "Failed to launch emulator : " + item.getName() + StringResources.NEW_LINE + StringResources.NEW_LINE + e.getMessage();
                }
                return this.returnMsg;
            }
        }, completionListener);
    }

    private static List<VMItem> copyItems(List<VMItem> items) {
        ArrayList<VMItem> itemList = new ArrayList<VMItem>();
        for (VMItem item : items) {
            itemList.add(item);
        }
        return itemList;
    }

    public static void delete(final List<VMItem> items) {
        assert (!items.isEmpty());
        String msg = "";
        msg = items.size() == 1 ? Messages.getString("VMEventHandler.Delete.0") + " " + items.get(0).getName() + "?" : Messages.getString("VMEventHandler.Delete.1");
        ButtonType returnType = MessageBox.confirm(msg, new ButtonType("Delete", ButtonBar.ButtonData.OK_DONE));
        if (returnType == null || returnType == ButtonType.CANCEL) {
            return;
        }
        EMLogger.getLogger().fine("Start progress indicator for delete: " + items.get(0).getName());
        VMEventHandler.setProgress(true);
        SimpleExecutor.asynExecute(new Callable<String>(){
            private String returnMsg;

            @Override
            public String call() throws Exception {
                List itemList = VMEventHandler.copyItems(items);
                this.returnMsg = "";
                for (VMItem item : itemList) {
                    EMLogger.getLogger().fine("Delete emulator: " + item.getName());
                    try {
                        item.delete();
                    }
                    catch (VMWorkerException e) {
                        this.returnMsg = this.returnMsg + Messages.getString("VMEventHandler.Delete.Failed") + item.getName() + StringResources.NEW_LINE + StringResources.NEW_LINE + e.getMessage();
                    }
                }
                return this.returnMsg;
            }
        }, completionListener);
    }

    public static void reset(final ObservableList<VMItem> items) {
        String msg = Messages.getString("VMEventHandler.Reset.0") + StringResources.NEW_LINE + Messages.getString("VMEventHandler.Reset.1") + StringResources.NEW_LINE + StringResources.NEW_LINE + Messages.getString("VMEventHandler.Reset.2");
        ButtonType returnType = MessageBox.confirm(msg, new ButtonType("Format", ButtonBar.ButtonData.OK_DONE));
        if (returnType == null || returnType == ButtonType.CANCEL) {
            return;
        }
        EMLogger.getLogger().fine("Start progress indicator for reset: " + ((VMItem)items.get(0)).getName());
        VMEventHandler.setProgress(true);
        SimpleExecutor.asynExecute(new Callable<String>(){
            private String returnMsg;

            @Override
            public String call() throws Exception {
                List itemList = VMEventHandler.copyItems((List)items);
                this.returnMsg = "";
                for (VMItem item : itemList) {
                    EMLogger.getLogger().fine("Reset emulator: " + item.getName());
                    try {
                        item.reset();
                    }
                    catch (VMWorkerException e) {
                        this.returnMsg = this.returnMsg + Messages.getString("VMEventHandler.Reset.Failed") + item.getName() + StringResources.NEW_LINE + StringResources.NEW_LINE + e.getMessage();
                    }
                }
                return this.returnMsg;
            }
        }, completionListener);
    }

    public static void export(final VMItem item) {
        String msg = Messages.getString("VMEventHandler.Export.0") + StringResources.NEW_LINE + Messages.getString("VMEventHandler.Export.1");
        String checkMsg = Messages.getString("VMEventHandler.Export.Check");
        final CheckReturn returnType = MessageBox.check(msg, checkMsg, ButtonType.CANCEL, new ButtonType("Export", ButtonBar.ButtonData.OK_DONE));
        if (returnType.getButtonType() == ButtonType.CANCEL) {
            return;
        }
        FileChooser fileChooser = new FileChooser();
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Image Files(*." + item.getImageArch(), new String[]{"*." + item.getImageArch()})});
        fileChooser.setTitle("Export 'Platform Image' as");
        fileChooser.setInitialDirectory(new File(FilePathResources.getTizenSDKDataEmulatorPath()));
        final File file = fileChooser.showSaveDialog((Window)Main.getPrimaryStage());
        if (file == null) {
            return;
        }
        SimpleExecutor.asynExecute(new Callable<String>(){
            private String returnMsg;

            @Override
            public String call() throws Exception {
                this.returnMsg = "";
                try {
                    item.export(file.getAbsolutePath(), returnType.isChecked());
                }
                catch (VMWorkerException e) {
                    this.returnMsg = "Failed to export as emulator." + StringResources.NEW_LINE + StringResources.NEW_LINE + e.getMessage();
                }
                return this.returnMsg;
            }
        }, completionListener);
    }

    public static void create(final VMPropertyValue value) {
        EMLogger.getLogger().fine("Start progress indicator for create: " + value.vmName);
        VMEventHandler.setProgress(true);
        SimpleExecutor.asynExecute(new Callable<String>(){
            private String returnMsg;

            @Override
            public String call() throws Exception {
                this.returnMsg = "";
                try {
                    Creator.create(value);
                }
                catch (VMWorkerException e) {
                    this.returnMsg = e.getMessage();
                }
                return this.returnMsg;
            }
        }, completionListener);
    }

    public static void modify(final VMItem item, final VMPropertyValue newValue) {
        assert (item != null);
        EMLogger.getLogger().fine("Start progress indicator for modify: " + item.getName());
        VMEventHandler.setProgress(true);
        SimpleExecutor.asynExecute(new Callable<String>(){
            private String returnMsg;

            @Override
            public String call() throws Exception {
                this.returnMsg = "";
                try {
                    item.modify(newValue);
                }
                catch (VMWorkerException e) {
                    this.returnMsg = e.getMessage();
                }
                return this.returnMsg;
            }
        }, completionListener);
    }

    private static void setProgress(boolean visible) {
        isVisible.set(visible);
    }
}

