/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.controller;

import org.tizen.emulator.manager.network.NetworkUtil;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.ui.Messages;
import org.tizen.emulator.manager.ui.dialog.ButtonType;
import org.tizen.emulator.manager.ui.dialog.MessageBox;
import org.tizen.emulator.manager.ui.dialog.network.TapGuideDialogForMac;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.controller.ComboViewController;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.template.item.Item;

public class NetConnectTypeItemController
extends ComboViewController {
    private String connectType = "NAT";
    private static Boolean MANUAL_BRIDGE = null;

    public NetConnectTypeItemController(Item item) {
        super(item);
    }

    @Override
    protected void onChangedValue(Event event) {
        String oldType = this.connectType;
        String type = this.comboView.getSelectedItem();
        if (type != null && !type.isEmpty()) {
            this.connectType = type;
        }
        if (!oldType.equals(this.connectType)) {
            ItemEvent iEvent = new ItemEvent(this.getName(), this);
            iEvent.oldValue = oldType;
            iEvent.newValue = this.connectType;
            iEvent.oldState = this.state;
            iEvent.newState = this.state;
            ViewItemController.sendChangeEvent(iEvent);
            if (OSUtil.isMac() && this.connectType.equals("Bridge")) {
                NetConnectTypeItemController.showGuideForMac();
            }
            this.checkValid();
        }
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        String type = value.getStringValue(this.getName());
        if (type != null && !type.isEmpty()) {
            this.connectType = type;
            this.comboView.selectItem(this.connectType);
        } else {
            this.comboView.selectItem(this.connectType);
        }
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        value.setStringValue(this.getName(), this.connectType);
    }

    @Override
    public void checkValid() {
    }

    private static void showGuideForMac() {
        if (MANUAL_BRIDGE == null) {
            MANUAL_BRIDGE = NetworkUtil.isBridgeGuideNecessaryForMac();
        }
        if (!MANUAL_BRIDGE.booleanValue()) {
            return;
        }
        if (!NetworkUtil.getBridgeNameForMac().isEmpty()) {
            return;
        }
        String message = Messages.getString("NetConnectTypeItem.showGuideForMac.1") + StringResources.NEW_LINE + Messages.getString("NetConnectTypeItem.showGuideForMac.2");
        ButtonType returnType = MessageBox.confirm(message);
        if (returnType == ButtonType.OK) {
            TapGuideDialogForMac.open();
        }
    }
}

