/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.controller;

import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.tabview.item.TextViewItem;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;
import org.tizen.emulator.manager.ui.template.item.Item;

public class TextViewController
extends ViewItemController {
    protected TextViewItem textView;

    public TextViewController(Item item) {
        super(item);
    }

    public TextViewController(Item item, ViewItemController parent) {
        super(item, parent);
    }

    @Override
    public void makeViewItem() {
        this.setViewItem(new TextViewItem());
    }

    @Override
    public ViewItem getViewItem() {
        return this.textView;
    }

    @Override
    public void setViewItem(ViewItem item) {
        this.textView = item instanceof TextViewItem ? (TextViewItem)item : new TextViewItem();
        this.textView.setTitle(this.getTitle());
        this.textView.setText("Text Widget");
        this.textView.addEventHandler(EventType.Modify, new EventHandler<Event>(){

            @Override
            public void handleEvent(Event event) {
                TextViewController.this.onChangedValue(event);
            }
        });
    }

    @Override
    protected void onChangedValue(Event event) {
        ItemEvent iEvent = new ItemEvent(this.getName(), this);
        iEvent.oldValue = "";
        iEvent.newValue = event.text;
        iEvent.oldState = this.state;
        iEvent.newState = this.state;
        ViewItemController.sendChangeEvent(iEvent);
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        String text = "";
        if (this.getLabelName() != null || this.parent != null) {
            String parentName = this.parent != null ? this.parent.getName() : this.getLabelName();
            text = value.getSubItemStringValue(parentName, this.getName());
            if (text == null || text.isEmpty()) {
                text = value.getStringValue(this.getName());
            }
        } else {
            text = value.getStringValue(this.getName());
        }
        if (text != null) {
            this.textView.setText(text);
        }
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        if (this.getLabelName() != null || this.parent != null) {
            String parentName = this.parent != null ? this.parent.getName() : this.getLabelName();
            value.setSubItemStringValue(parentName, this.getName(), this.textView.getText());
        } else {
            value.setStringValue(this.getName(), this.textView.getText());
        }
    }

    @Override
    public void checkValid() {
    }
}

