/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.template.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.tizen.emulator.manager.EmulatorManagerMode;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.ui.template.item.Option;

public class Item
implements Cloneable {
    private String name = "";
    private String title = "";
    private String type = "";
    private boolean isExperimental = false;
    private boolean isSupportOS = true;
    private MODE supportMode = MODE.NONE;
    private String defaultValue = "";
    private final List<Option> options = new ArrayList<Option>();
    private final List<Item> subItems = new ArrayList<Item>();

    public Item() {
    }

    public Item clone() {
        Item item = new Item(this.name, this.title);
        item.type = this.type;
        item.isExperimental = this.isExperimental;
        item.isSupportOS = this.isSupportOS;
        item.defaultValue = this.defaultValue;
        for (Option opt : this.options) {
            item.options.add(opt.clone());
        }
        for (Item subItem : this.subItems) {
            item.subItems.add(subItem.clone());
        }
        return item;
    }

    public Item(String name, String title) {
        this.name = name;
        this.title = title;
    }

    public String toString(String space) {
        String newLine = StringResources.NEW_LINE;
        String str = space + "[Item] name: " + this.name + ", title: " + this.title + ", type: " + this.type + newLine;
        for (Option option : this.getOptions()) {
            str = str + option.toString(space + "    ");
        }
        for (Item item : this.getSubItems()) {
            str = str + item.toString(space + "    ");
        }
        return str;
    }

    public String toString() {
        return this.toString("");
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getType() {
        return this.type;
    }

    public void addOption(Option option) {
        this.options.add(option);
        String name = option.getName();
        if (name.equals("experimental") && !EmulatorManagerMode.isInhouseMode()) {
            this.isExperimental = option.getValue().equals("true");
        } else if (name.equals("supportOS")) {
            List<String> osList = Arrays.asList(option.getValue().trim().split("\\s{0,},\\s{0,}"));
            if (OSUtil.isWin() && !osList.contains("win")) {
                this.isSupportOS = false;
            }
            if (OSUtil.isLinux() && !osList.contains("linux")) {
                this.isSupportOS = false;
            }
            if (OSUtil.isMac() && !osList.contains("mac")) {
                this.isSupportOS = false;
            }
        } else if (name.equals("defaultValue")) {
            this.defaultValue = option.getValue();
        } else if (name.equals("supportMode")) {
            String mode = option.getValue();
            if (mode.equals("create")) {
                this.supportMode = MODE.CREATE;
            } else if (mode.equals("modify")) {
                this.supportMode = MODE.MODIFY;
            } else if (mode.equals("detail")) {
                this.supportMode = MODE.DETAIL;
            }
        }
    }

    public List<Item> getSubItems() {
        return this.subItems;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public void addSubItem(Item item) {
        this.subItems.add(item);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isExperimental() {
        return this.isExperimental;
    }

    public boolean isSupportOS() {
        return this.isSupportOS;
    }

    public void setSupportOS(boolean support) {
        this.isSupportOS = support;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public MODE getSupportMode() {
        return this.supportMode;
    }

    public void setSupportMode(MODE supportMode) {
        this.supportMode = supportMode;
    }
}

