/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.create;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.WindowEvent;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.platform.PlatformList;
import org.tizen.emulator.manager.platform.custom.CustomPlatform;
import org.tizen.emulator.manager.platform.custom.CustomPlatformImageValue;
import org.tizen.emulator.manager.platform.custom.CustomPlatformImageWorker;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.ui.control.ButtonToggleEvent;
import org.tizen.emulator.manager.ui.control.ImageButton;
import org.tizen.emulator.manager.ui.controller.create.PlatformPropertyView;
import org.tizen.emulator.manager.ui.controller.create.PlatformTreeCell;
import org.tizen.emulator.manager.ui.controller.create.PlatformTreeData;
import org.tizen.emulator.manager.ui.controller.vms.ROW_STATE;
import org.tizen.emulator.manager.ui.dialog.ButtonBar;
import org.tizen.emulator.manager.ui.dialog.ButtonType;
import org.tizen.emulator.manager.ui.dialog.MessageBox;
import org.tizen.emulator.manager.ui.resources.ImageKind;
import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.vms.DiskImageFormat;

public class PlatformListController
implements Initializable {
    @FXML
    private StackPane fxStackPane;
    @FXML
    private VBox fxRootPane;
    @FXML
    private HBox buttonBox;
    private ImageButton editBtn;
    private ImageButton deleteBtn;
    private ImageButton addBtn;
    private final SimpleStringProperty selectedProfile = new SimpleStringProperty();
    private final int PROPERTY_VIEW_WIDTH = 370;
    static final int PROPERTY_VIEW_HEIGHT = 493;
    @FXML
    private TreeView<PlatformTreeData> treeView;
    private TreeItem<PlatformTreeData> treeRoot;
    PlatformPropertyView view;

    private void openPropertyView(MODE mode) {
        this.view = new PlatformPropertyView(mode);
        CustomPlatformImageValue value = new CustomPlatformImageValue();
        if (mode == MODE.CREATE) {
            value.setProfile(this.selectedProfile.get());
        } else {
            CustomPlatform platform = (CustomPlatform)((PlatformTreeData)((TreeItem)this.treeView.getSelectionModel().getSelectedItem()).getValue()).getPlatform();
            value.setName(platform.getName());
            value.setPlatform(platform.getBasePlatform());
            value.setProfile(platform.getProfile().getName());
            for (String path : platform.getImagePathList()) {
                value.getPathList().add(path);
            }
            value.setDescription(platform.getImageDescription());
            value.setImageFormat(platform.getImageFormat());
        }
        this.view.setPlatformValue(value);
        this.view.createItems();
        this.view.setCancelButtonClicked(new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                PlatformListController.this.closePropertyView();
            }
        });
        this.view.setConfirmButtonClicked(new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                CustomPlatformImageValue value = PlatformListController.this.view.getPlatformValue();
                MODE mode = PlatformListController.this.view.getMode();
                if (mode == MODE.CREATE) {
                    PlatformListController.this.createPlatform(value);
                } else if (mode == MODE.MODIFY) {
                    PlatformListController.this.modifyPlatform(value);
                }
                PlatformListController.this.closePropertyView();
            }
        });
        this.view.openPropertyView("Platform Configuration", 370, 493);
        this.view.getButtons().getButton(ButtonType.OK).requestFocus();
        this.view.setOnClosed(new EventHandler<WindowEvent>(){

            public void handle(WindowEvent arg0) {
                PlatformListController.this.addBtn.setSelected(false);
                PlatformListController.this.editBtn.setSelected(false);
            }
        });
    }

    private void createPlatform(CustomPlatformImageValue value) {
        Platform platform = value.getImageFormat() == DiskImageFormat.QCOW2 ? CustomPlatformImageWorker.create(value) : Platform.createTemporaryCustomInstance(value);
        this.treeView.getSelectionModel().select(this.addTreeItem(platform));
        this.treeView.scrollTo(this.treeView.getSelectionModel().getSelectedIndex());
    }

    private void modifyPlatform(CustomPlatformImageValue value) {
        TreeItem treeItem = (TreeItem)this.treeView.getSelectionModel().selectedItemProperty().get();
        int index = 0;
        TreeItem profileItem = null;
        for (TreeItem item : this.treeRoot.getChildren()) {
            if (!((PlatformTreeData)item.getValue()).getProfile().equals(((PlatformTreeData)treeItem.getValue()).getProfile())) continue;
            index = item.getChildren().indexOf((Object)treeItem);
            profileItem = item;
        }
        CustomPlatform platform = (CustomPlatform)((PlatformTreeData)treeItem.getValue()).getPlatform();
        CustomPlatformImageWorker.modify(platform, value);
        if (profileItem == null) {
            this.addTreeItem(platform);
        } else {
            profileItem.getChildren().remove((Object)treeItem);
            profileItem.getChildren().add(index, (Object)treeItem);
        }
        this.treeView.getSelectionModel().select((Object)treeItem);
    }

    private void addClicked(boolean isOpen) {
        if (isOpen) {
            this.openPropertyView(MODE.CREATE);
        } else {
            this.closePropertyView();
        }
    }

    private void editClicked(boolean isOpen) {
        if (isOpen) {
            this.openPropertyView(MODE.MODIFY);
        } else {
            this.closePropertyView();
        }
    }

    private void deleteClicked() {
        ButtonType returnType = MessageBox.confirm("Are you sure you want to delete" + StringResources.NEW_LINE + "the selected custom platform?", new ButtonType("Delete", ButtonBar.ButtonData.OK_DONE));
        if (returnType == ButtonType.CANCEL) {
            return;
        }
        TreeItem treeItem = (TreeItem)this.treeView.getSelectionModel().selectedItemProperty().get();
        int index = 0;
        TreeItem profileItem = null;
        for (TreeItem item : this.treeRoot.getChildren()) {
            if (!((PlatformTreeData)item.getValue()).getProfile().equals(((PlatformTreeData)treeItem.getValue()).getProfile())) continue;
            index = item.getChildren().indexOf((Object)treeItem);
            profileItem = item;
        }
        Platform platform = ((PlatformTreeData)treeItem.getValue()).getPlatform();
        if (!CustomPlatformImageWorker.delete((CustomPlatform)platform, false)) {
            // empty if block
        }
        if (profileItem != null) {
            profileItem.getChildren().remove((Object)treeItem);
        }
        if (profileItem.getChildren().size() == index) {
            if (profileItem.getChildren().size() == 0) {
                this.treeView.getSelectionModel().select((Object)profileItem);
            } else {
                this.treeView.getSelectionModel().select(profileItem.getChildren().get(index - 1));
            }
        } else {
            this.treeView.getSelectionModel().select(profileItem.getChildren().get(index));
        }
    }

    private void closePropertyView() {
        this.view.removeChangeEventHandler();
        this.view.closePropertyView();
    }

    public void initialize(URL arg0, ResourceBundle arg1) {
        this.fxRootPane.getStyleClass().add((Object)"root-pane");
        this.fxRootPane.setPadding(new Insets(0.0, 20.0, 20.0, 20.0));
        this.initButtons();
        this.initPlatformTreeView();
    }

    private void initPlatformTreeView() {
        this.treeRoot = new TreeItem();
        this.treeRoot.setExpanded(true);
        this.treeView.setRoot(this.treeRoot);
        for (Platform platform : PlatformList.getList()) {
            this.addTreeItem(platform);
        }
        this.treeView.setCellFactory(PlatformTreeCell.extractor());
        this.treeView.setShowRoot(false);
        this.treeView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<TreeItem<PlatformTreeData>>(){

            public void changed(ObservableValue<? extends TreeItem<PlatformTreeData>> arg0, TreeItem<PlatformTreeData> arg1, TreeItem<PlatformTreeData> arg2) {
                if (arg2 == null) {
                    return;
                }
                ((PlatformTreeData)arg2.getValue()).getState().set((Object)ROW_STATE.SELECTED);
                PlatformListController.this.selectedProfile.set(((PlatformTreeData)arg2.getValue()).getProfile());
                TreeItem currentParent = ((PlatformTreeData)arg2.getValue()).isRoot() ? arg2 : arg2.getParent();
                for (TreeItem parentItem : PlatformListController.this.treeRoot.getChildren()) {
                    ((PlatformTreeData)parentItem.getValue()).getState().set((Object)(parentItem == currentParent ? ROW_STATE.SELECTED : ROW_STATE.NORMAL));
                }
                if (arg1 == null) {
                    return;
                }
                if (arg1 == arg2.getParent()) {
                    return;
                }
                ((PlatformTreeData)arg1.getValue()).getState().set((Object)ROW_STATE.NORMAL);
            }
        });
        this.setStatus();
    }

    private void setStatus() {
        this.addBtn.setDisable(true);
        this.deleteBtn.setDisable(true);
        this.editBtn.setDisable(true);
        if (PlatformList.getList().isEmpty()) {
            this.fxStackPane.getChildren().clear();
            Label label = new Label();
            label.setText("The platform is not installed." + StringResources.NEW_LINE + StringResources.NEW_LINE + "To create emulator, close the emulator manager," + StringResources.NEW_LINE + "launch the 'Package Manager', install the platform.");
            this.fxStackPane.getChildren().add((Object)label);
            this.fxStackPane.setVisible(true);
        } else {
            this.addBtn.setDisable(false);
            this.fxStackPane.setVisible(false);
        }
    }

    private TreeItem<PlatformTreeData> addTreeItem(Platform platform) {
        TreeItem treeItem = new TreeItem((Object)new PlatformTreeData(platform));
        boolean found = false;
        for (TreeItem profileItem : this.treeRoot.getChildren()) {
            if (!((PlatformTreeData)profileItem.getValue()).getProfile().equals(platform.getProfile().getName())) continue;
            profileItem.getChildren().add((Object)treeItem);
            found = true;
            break;
        }
        if (!found) {
            final TreeItem profileItem = new TreeItem();
            PlatformTreeData data = new PlatformTreeData(platform, profileItem.expandedProperty());
            profileItem.setValue((Object)data);
            this.treeRoot.getChildren().add((Object)profileItem);
            profileItem.getChildren().add((Object)treeItem);
            profileItem.expandedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                    if (arg2 == null) {
                        return;
                    }
                    if (PlatformListController.this.treeView.getSelectionModel().getSelectedItem() != profileItem) {
                        PlatformListController.this.treeView.getSelectionModel().select((Object)profileItem);
                        if (!arg2.booleanValue()) {
                            profileItem.setExpanded(false);
                        }
                    }
                }
            });
        }
        return treeItem;
    }

    public void selectDefaultPlatform(Platform platform) {
        if (platform != null) {
            return;
        }
        for (TreeItem profileItem : this.treeRoot.getChildren()) {
            profileItem.setExpanded(false);
        }
        if (this.treeRoot.getChildren().size() > 0 && ((TreeItem)this.treeRoot.getChildren().get(0)).getChildren().size() > 0) {
            this.treeView.getSelectionModel().select(((TreeItem)this.treeRoot.getChildren().get(0)).getChildren().get(0));
        }
    }

    private void initButtons() {
        this.buttonBox.setAlignment(Pos.CENTER_RIGHT);
        this.buttonBox.setSpacing(14.0);
        this.buttonBox.setPadding(new Insets(0.0, 14.0, 0.0, 0.0));
        this.editBtn = new ImageButton(ImageKind.PLATFORM_EDIT_NOR, ImageKind.PLATFORM_EDIT_OVER, ImageKind.PLATFORM_EDIT_SEL, ImageKind.PLATFORM_EDIT_SEL);
        this.deleteBtn = new ImageButton(ImageKind.PLATFORM_DELETE_NOR, ImageKind.PLATFORM_DELETE_OVER, ImageKind.PLATFORM_DELETE_SEL);
        this.addBtn = new ImageButton(ImageKind.PLATFORM_ADD_NOR, ImageKind.PLATFORM_ADD_OVER, ImageKind.PLATFORM_ADD_SEL, ImageKind.PLATFORM_ADD_SEL);
        this.buttonBox.getChildren().addAll((Object[])new Node[]{this.editBtn.getPane(), this.addBtn.getPane(), this.deleteBtn.getPane()});
        this.addBtn.setOnSelected(new EventHandler<ButtonToggleEvent>(){

            public void handle(ButtonToggleEvent arg0) {
                PlatformListController.this.addClicked(arg0.isSelected());
            }
        });
        this.editBtn.setOnSelected(new EventHandler<ButtonToggleEvent>(){

            public void handle(ButtonToggleEvent arg0) {
                PlatformListController.this.editClicked(arg0.isSelected());
            }
        });
        this.deleteBtn.setOnMouseClicked(new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                PlatformListController.this.deleteClicked();
            }
        });
        this.treeView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<TreeItem<PlatformTreeData>>(){

            public void changed(ObservableValue<? extends TreeItem<PlatformTreeData>> arg0, TreeItem<PlatformTreeData> arg1, TreeItem<PlatformTreeData> arg2) {
                if (arg2 == null) {
                    return;
                }
                boolean isDisable = ((PlatformTreeData)arg2.getValue()).isRoot() || !((PlatformTreeData)arg2.getValue()).isCustom();
                PlatformListController.this.editBtn.setDisable(isDisable);
                PlatformListController.this.deleteBtn.setDisable(isDisable);
            }
        });
    }

    void setInvalidListener(final SimpleBooleanProperty isInvalid) {
        if (this.treeView.getRoot().getChildren().isEmpty()) {
            isInvalid.set(true);
        }
        this.treeView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<TreeItem<PlatformTreeData>>(){

            public void changed(ObservableValue<? extends TreeItem<PlatformTreeData>> arg0, TreeItem<PlatformTreeData> arg1, TreeItem<PlatformTreeData> arg2) {
                if (arg2 == null || ((PlatformTreeData)arg2.getValue()).isRoot()) {
                    isInvalid.set(true);
                } else {
                    isInvalid.set(false);
                }
            }
        });
    }

    Platform getPlatform() {
        return ((PlatformTreeData)((TreeItem)this.treeView.getSelectionModel().getSelectedItem()).getValue()).getPlatform();
    }

    Pane getRootPane() {
        return this.fxRootPane;
    }
}

