/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.option;

import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.exception.VMWorkerException;
import org.tizen.emulator.manager.vms.option.LaunchConfig;
import org.tizen.emulator.manager.vms.option.OPTION_KEY;
import org.tizen.emulator.manager.vms.option.Option;
import org.tizen.emulator.manager.vms.option.RemoteOption;

public class DisplayModeOption
extends Option {
    public static final String MARU_QT = "maru_qt";
    protected final String MARU_SDL = "maru_sdl";
    protected final String MARU_SHM = "maru_shm";

    @Override
    public void getLaunchArgument(LaunchConfig config, VMProperty property) throws VMWorkerException {
        if (DisplayModeOption.isLesserThan(property.getPropertyValue().getImageVersion(), "2.3.2")) {
            return;
        }
        boolean useDirectRendering = property.getPropertyValue().getAdvancedOption("displayMode") != null ? this.checkOnOrEmpty(property.getPropertyValue().getAdvancedSubOptionValue("displayMode", "qtEnable")) : true;
        if (useDirectRendering) {
            if (RemoteOption.isRemoteMode(property)) {
                return;
            }
            String rendering = null;
            rendering = !OSUtil.isMac() && property.getPropertyValue().isGLAcceleration ? "onscreen" : "offscreen";
            config.appendQemuOptions("-display", MARU_QT, "rendering=" + rendering + ",resolution=" + DisplayModeOption.varForm(OPTION_KEY.VAR_DISPLAY_RESOLUTION) + ",dpi=" + DisplayModeOption.varForm(OPTION_KEY.VAR_DISPLAY_PIXEL_DENSITY));
        } else if (OSUtil.isMac()) {
            config.addQemuOption("-display", "maru_shm");
        } else {
            config.addQemuOption("-display", "maru_sdl");
        }
    }
}

