/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.platform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tizen.emulator.manager.plugin.EMPlugin;

class EMPluginTree {
    List<PluginNode> rootList = new ArrayList<PluginNode>();
    Map<EMPlugin, PluginNode> map = new HashMap<EMPlugin, PluginNode>();

    EMPluginTree() {
    }

    void addChild(EMPlugin parent, EMPlugin child) {
        PluginNode parentNode = this.addNode(parent);
        parentNode.addChild(this.addNode(child));
    }

    void addRoot(EMPlugin plugin) {
        PluginNode node = this.addNode(plugin);
        this.rootList.add(node);
    }

    private PluginNode addNode(EMPlugin plugin) {
        if (this.map.get(plugin) == null) {
            this.map.put(plugin, new PluginNode(plugin));
        }
        return this.map.get(plugin);
    }

    protected List<EMPlugin> getPlugins() {
        ArrayList<EMPlugin> list = new ArrayList<EMPlugin>();
        for (PluginNode node : this.rootList) {
            EMPluginTree.addToList(list, node);
        }
        return list;
    }

    private static void addToList(List<EMPlugin> list, PluginNode node) {
        list.add(node.getData());
        for (PluginNode child : node.getChildren()) {
            EMPluginTree.addToList(list, child);
        }
    }

    class PluginNode {
        EMPlugin data;
        List<PluginNode> children = new ArrayList<PluginNode>();

        PluginNode(EMPlugin plugin) {
            this.data = plugin;
        }

        void addChild(PluginNode child) {
            this.children.add(child);
        }

        EMPlugin getData() {
            return this.data;
        }

        List<PluginNode> getChildren() {
            return this.children;
        }
    }
}

