/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.platform;

import java.util.SortedSet;
import java.util.TreeSet;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.platform.custom.CustomPlatform;

public class PlatformList {
    private static SortedSet<Platform> platformList = new TreeSet<Platform>();

    static synchronized void add(Platform platform) {
        platformList.add(platform);
    }

    public static synchronized void remove(Platform platform) {
        platformList.remove(platform);
    }

    public static SortedSet<Platform> getList() {
        return platformList;
    }

    public static synchronized void clearList() {
        platformList.clear();
    }

    public static synchronized Platform get(String platformName) {
        if (platformName == null || platformName.isEmpty()) {
            return null;
        }
        for (Platform platform : platformList) {
            if (!platform.getName().equals(platformName)) continue;
            return platform;
        }
        return null;
    }

    public static Platform getLatest(String profile) {
        Platform latestPlatform = null;
        for (Platform platform : platformList) {
            if (platform instanceof CustomPlatform || !platform.getProfile().equals(profile)) continue;
            if (latestPlatform == null) {
                latestPlatform = platform;
            }
            if (platform.getVersion().compareTo(latestPlatform.getVersion()) <= 0) continue;
            latestPlatform = platform;
        }
        return latestPlatform;
    }
}

