/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms;

import java.util.ArrayList;
import java.util.List;

public class VMOption
implements Cloneable {
    private String name = "";
    private String value = null;
    protected Object data = null;
    private List<VMOption> subOptionList = new ArrayList<VMOption>();

    public VMOption(String name) {
        this(name, null);
    }

    public VMOption(String name, String value) {
        assert (name != null);
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public List<VMOption> getSubOptionList() {
        return this.subOptionList;
    }

    public VMOption getSubOption(String subName) {
        for (VMOption option : this.subOptionList) {
            if (!option.getName().equals(subName)) continue;
            return option;
        }
        return null;
    }

    public void addSubOption(VMOption subOption) {
        if (subOption == null) {
            return;
        }
        this.subOptionList.add(subOption);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VMOption)) {
            return false;
        }
        VMOption dest = (VMOption)obj;
        if (!this.name.equals(dest.getName())) {
            return false;
        }
        if (this.value == null && dest.getValue() != null) {
            return false;
        }
        if (this.value != null) {
            if (dest.getValue() == null) {
                return false;
            }
            if (!this.value.equals(dest.getValue())) {
                return false;
            }
        }
        if (this.data == null && dest.getData() != null) {
            return false;
        }
        if (this.data != null) {
            if (dest.getData() == null) {
                return false;
            }
            if (!this.data.equals(dest.getData())) {
                return false;
            }
        }
        block0: for (VMOption srcSub : this.subOptionList) {
            for (VMOption destSub : dest.subOptionList) {
                if (!srcSub.getName().equals(destSub.getName())) continue;
                if (srcSub.equals(destSub)) continue block0;
                return false;
            }
        }
        return true;
    }

    public VMOption clone() {
        VMOption option = new VMOption(this.name);
        option.setValue(this.value);
        option.setData(this.data);
        for (VMOption srcSub : this.getSubOptionList()) {
            VMOption subOption = srcSub.clone();
            option.addSubOption(subOption);
        }
        return option;
    }
}

