/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.option;

import org.tizen.emulator.manager.Messages;
import org.tizen.emulator.manager.concurrent.overseer.CheckVT;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.exception.VMLauncherException;
import org.tizen.emulator.manager.vms.option.LaunchConfig;
import org.tizen.emulator.manager.vms.option.OPTION_KEY;
import org.tizen.emulator.manager.vms.option.Option;
import org.tizen.emulator.manager.vms.type.CPU;

public class ProcessorOption
extends Option {
    @Override
    public void getLaunchArgument(LaunchConfig config, VMProperty property) {
        if (ProcessorOption.isEqual(property.getPropertyValue().getImageVersion(), "2.3")) {
            return;
        }
        config.addVariable(OPTION_KEY.VAR_PROCESS_NUM, String.valueOf(this.getCpuNum(property)));
        config.addQemuOption("-smp", ProcessorOption.varForm(OPTION_KEY.VAR_PROCESS_NUM));
    }

    @Override
    public void checkArgument(VMProperty property) throws VMLauncherException {
        int cpu = this.getCpuNum(property);
        if (CheckVT.isNonUG() && cpu > 1) {
            throw new VMLauncherException(Messages.getString("ProcessorOption.MultiInfo.0") + StringResources.NEW_LINE + Messages.getString("ProcessorOption.MultiInfo.1"));
        }
    }

    private int getCpuNum(VMProperty property) {
        int cpuCount = property.getPropertyValue().cpu;
        if (cpuCount != 0) {
            return cpuCount;
        }
        if (CheckVT.isNonUG()) {
            return 1;
        }
        CPU cpu = CPU.values().get(CPU.values().size() - 1);
        if (cpu.getValue() > 4) {
            return 4;
        }
        return cpu.getValue();
    }
}

