/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.ui.template.item.Item;
import org.tizen.emulator.manager.ui.template.item.Option;
import org.tizen.emulator.manager.vms.type.RESOLUTION;

public class TemplateUtil {
    public static final int DEFAULT_NUM_COLUMN = 3;

    public static int getNumColomnOption(Item item) {
        int numColumn = 3;
        for (Option opt : item.getOptions()) {
            if (!opt.getName().equals("numColumn")) continue;
            try {
                numColumn = Integer.parseInt(opt.getValue());
            }
            catch (NumberFormatException e) {
                EMLogger.getLogger().warning(e.getMessage());
            }
            break;
        }
        return numColumn;
    }

    public static int getCheckBoxNumColumn(Item item) {
        int numColumn = 3;
        String str = TemplateUtil.getOption(item.getOptions(), "numColumn");
        if (str != null) {
            try {
                numColumn = Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                EMLogger.getLogger().warning(e.getMessage());
            }
        }
        return numColumn;
    }

    public static String getOption(List<Option> options, String optionName) {
        String option = null;
        for (Option opt : options) {
            if (!opt.getName().equals(optionName)) continue;
            option = opt.getValue();
        }
        return option;
    }

    public static Map<String, String> getProxyItemMap(List<Option> optionList) {
        HashMap<String, String> optionMap = new HashMap<String, String>();
        for (Option option : optionList) {
            if (!option.getName().equals("none") && !option.getName().equals("auto") && !option.getName().equals("manual")) continue;
            optionMap.put(option.getName(), option.getValue());
        }
        return optionMap;
    }

    public static Map<String, String> getOptionMap(List<Option> optionList) {
        HashMap<String, String> optionMap = new HashMap<String, String>();
        for (Option option : optionList) {
            optionMap.put(option.getName(), option.getValue());
        }
        return optionMap;
    }

    public static String getDefaultValue(List<Option> optionList) {
        for (Option option : optionList) {
            if (!option.getName().equals("defaultValue")) continue;
            return option.getValue();
        }
        return null;
    }

    public static List<String> getOptionList(List<Option> optionList) {
        Option option;
        ArrayList<String> resultList = new ArrayList<String>();
        Iterator<Option> i$ = optionList.iterator();
        if (i$.hasNext() && (option = i$.next()).getName().equals("list")) {
            String[] split;
            for (String s : split = option.getValue().split(",")) {
                resultList.add(s.trim());
            }
        }
        return resultList;
    }

    public static List<RESOLUTION> getResolutionList(Item item) {
        Item displayItem = TemplateUtil.getSubItem(item, "resolution");
        if (displayItem == null) {
            return new ArrayList<RESOLUTION>();
        }
        ArrayList<RESOLUTION> list = new ArrayList<RESOLUTION>();
        for (Option opt : displayItem.getOptions()) {
            String[] split;
            if (opt.isExperimental() || (split = opt.getValue().split(",")).length != 4) continue;
            RESOLUTION resolution = null;
            for (String s : split) {
                try {
                    String name = split[0].trim();
                    int width = Integer.parseInt(split[1].trim());
                    int height = Integer.parseInt(split[2].trim());
                    int dpi = Integer.parseInt(split[3].trim());
                    resolution = new RESOLUTION(width, height, name, dpi);
                }
                catch (NumberFormatException e) {
                    EMLogger.getLogger().warning("Failed to parse Resolution : " + s);
                }
            }
            if (resolution == null) continue;
            list.add(resolution);
        }
        return list;
    }

    public static Item getSubItem(Item item, String itemName) {
        for (Item subItem : item.getSubItems()) {
            if (!subItem.getName().equals(itemName)) continue;
            return subItem;
        }
        return null;
    }

    public static boolean checkItemAvailable(Item item) {
        if (item.isExperimental()) {
            return false;
        }
        return item.isSupportOS();
    }
}

