/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.platform;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.platform.PlatformStringResources;
import org.tizen.emulator.manager.vms.DiskImageFormat;
import org.tizen.emulator.manager.vms.type.Architecture;
import org.tizen.emulator.manager.vms.type.SKIN_SHAPE;

class StandardPlatformImageValue {
    private final List<String> pathList = new ArrayList<String>();
    private DiskImageFormat imageFormat;
    private String imageName;
    private String profile;
    private String extension;
    private String version;
    private final String description = "";
    private String type;
    private Architecture cpu;
    private SKIN_SHAPE skinShape;
    private String binaryVersion;

    public static StandardPlatformImageValue createInstance(File imageDir) {
        if (imageDir == null || !imageDir.exists()) {
            return null;
        }
        StandardPlatformImageValue value = null;
        try {
            value = new StandardPlatformImageValue(imageDir);
        }
        catch (IOException e) {
            EMLogger.getLogger().warning(e.getMessage());
        }
        return value;
    }

    private StandardPlatformImageValue(File imageDir) throws IOException {
        this.settingProperty(imageDir);
        this.settingImagePath(imageDir);
        if (this.imageName == null || this.imageName.isEmpty()) {
            throw new IOException("Image name is empty. This image can not be added.");
        }
        this.imageFormat = DiskImageFormat.QCOW2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void settingProperty(File path) throws IOException {
        File info = new File(path + File.separator + "info.ini");
        FileInputStream inputStream = null;
        try {
            if (!info.exists()) {
                throw new IOException("info.ini file does not exist.");
            }
            inputStream = new FileInputStream(info);
            Properties prop = new Properties();
            prop.load(inputStream);
            this.imageName = prop.getProperty("name", "");
            this.version = prop.getProperty("version", "2.4");
            this.profile = prop.getProperty("profile", PlatformStringResources.MOBILE_PROFILE).toLowerCase();
            this.extension = prop.getProperty("profile.ext", "");
            this.type = prop.getProperty("type", "default");
            String cpuValue = prop.getProperty("cpu", "i386");
            this.cpu = Architecture.getType(cpuValue);
            this.skinShape = SKIN_SHAPE.find(prop.getProperty("skin.shape", "square"));
            this.binaryVersion = prop.getProperty("binary_version", "1.0.0");
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    EMLogger.getLogger().log(Level.WARNING, e.getMessage());
                }
            }
        }
    }

    private void settingImagePath(File dir) throws IOException {
        for (File f : dir.listFiles()) {
            if (!f.isFile() || !f.getName().endsWith(this.getArchitecture().name())) continue;
            this.pathList.add(f.getCanonicalPath());
        }
        if (this.pathList.isEmpty()) {
            throw new IOException("Failed getting image file path.");
        }
    }

    public String getName() {
        return this.imageName;
    }

    public List<String> getPathList() {
        return this.pathList;
    }

    public void addPath(String path) {
        this.pathList.add(path);
    }

    public DiskImageFormat getImageFormat() {
        return this.imageFormat;
    }

    public void setImageFormat(DiskImageFormat format) {
        this.imageFormat = format;
    }

    public String getProfile() {
        return this.profile;
    }

    public String getVersion() {
        return this.version;
    }

    public String getProfileExtension() {
        return this.extension;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public Architecture getArchitecture() {
        return this.cpu;
    }

    public String getBinaryVersion() {
        return this.binaryVersion;
    }

    public SKIN_SHAPE getSkinShape() {
        return this.skinShape;
    }
}

