/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.create;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.WindowEvent;
import org.tizen.emulator.manager.devices.DeviceTemplate;
import org.tizen.emulator.manager.devices.DeviceTemplateList;
import org.tizen.emulator.manager.devices.DeviceTemplatePriority;
import org.tizen.emulator.manager.devices.DeviceTemplateType;
import org.tizen.emulator.manager.devices.DeviceTemplateValue;
import org.tizen.emulator.manager.devices.DeviceWorkerException;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.ui.control.ImageButton;
import org.tizen.emulator.manager.ui.controller.create.DeviceTemplateData;
import org.tizen.emulator.manager.ui.controller.create.DeviceTemplateListCell;
import org.tizen.emulator.manager.ui.controller.create.DeviceTemplatePropertyView;
import org.tizen.emulator.manager.ui.controller.create.VMDialogData;
import org.tizen.emulator.manager.ui.controller.vms.ROW_STATE;
import org.tizen.emulator.manager.ui.dialog.ButtonBar;
import org.tizen.emulator.manager.ui.dialog.ButtonType;
import org.tizen.emulator.manager.ui.dialog.MessageBox;
import org.tizen.emulator.manager.ui.resources.ImageKind;
import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.ui.tabview.STATE;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;

public class DeviceTemplateListController
implements Initializable {
    @FXML
    private VBox rootPane;
    @FXML
    private HBox buttonBox;
    private ImageButton refreshBtn;
    private ImageButton editBtn;
    private ImageButton cloneBtn;
    private ImageButton deleteBtn;
    private ImageButton addBtn;
    private final int PROPERTY_VIEW_WIDTH = 400;
    static final int PROPERTY_VIEW_HEIGHT = 540;
    private VMDialogData dialogData;
    private Platform platform;
    @FXML
    private ListView<DeviceTemplateData> listView;
    ObservableList<DeviceTemplateData> listData = FXCollections.observableArrayList();

    public void initialize(URL arg0, ResourceBundle arg1) {
        this.rootPane.getStyleClass().add((Object)"root-pane");
        this.rootPane.setPadding(new Insets(0.0, 20.0, 20.0, 20.0));
        this.initButtons();
        this.initListView();
    }

    private void initListView() {
        this.listView.setItems(this.listData);
        this.listView.setCellFactory(DeviceTemplateListCell.extractor());
        this.listView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<DeviceTemplateData>(){

            public void changed(ObservableValue<? extends DeviceTemplateData> arg0, DeviceTemplateData arg1, DeviceTemplateData arg2) {
                if (arg2 == null) {
                    return;
                }
                arg2.getState().set((Object)ROW_STATE.SELECTED);
                for (DeviceTemplateData data : DeviceTemplateListController.this.listData) {
                    if (data.getName().equals(arg2.getName())) continue;
                    data.getState().set((Object)ROW_STATE.NORMAL);
                }
                ItemEvent iEvent = new ItemEvent("deviceTemplate");
                iEvent.oldValue = arg1 == null ? "" : arg1.getName();
                iEvent.newValue = arg2.getName();
                iEvent.oldState = STATE.OK;
                iEvent.newState = STATE.OK;
                iEvent.data = arg2.getTemplate();
                ViewItemController.sendChangeEvent(iEvent);
            }
        });
        this.listView.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.DELETE) {
                    DeviceTemplateListController.this.deleteClicked();
                }
            }
        });
    }

    private void initButtons() {
        this.buttonBox.getStyleClass().add((Object)"menu-buttons");
        this.buttonBox.setAlignment(Pos.CENTER_RIGHT);
        this.buttonBox.setSpacing(14.0);
        this.refreshBtn = new ImageButton(ImageKind.PLATFORM_REFRESH_NOR, ImageKind.PLATFORM_REFRESH_OVER, ImageKind.PLATFORM_REFRESH_SEL);
        this.editBtn = new ImageButton(ImageKind.PLATFORM_EDIT_NOR, ImageKind.PLATFORM_EDIT_OVER, ImageKind.PLATFORM_EDIT_SEL, ImageKind.PLATFORM_EDIT_SEL);
        this.cloneBtn = new ImageButton(ImageKind.PLATFORM_CLONE_NOR, ImageKind.PLATFORM_CLONE_OVER, ImageKind.PLATFORM_CLONE_SEL, ImageKind.PLATFORM_CLONE_SEL);
        this.deleteBtn = new ImageButton(ImageKind.PLATFORM_DELETE_NOR, ImageKind.PLATFORM_DELETE_OVER, ImageKind.PLATFORM_DELETE_SEL);
        this.addBtn = new ImageButton(ImageKind.PLATFORM_ADD_NOR, ImageKind.PLATFORM_ADD_OVER, ImageKind.PLATFORM_ADD_SEL, ImageKind.PLATFORM_ADD_SEL);
        this.buttonBox.getChildren().addAll((Object[])new Node[]{this.refreshBtn.getPane(), this.editBtn.getPane(), this.cloneBtn.getPane(), this.addBtn.getPane(), this.deleteBtn.getPane()});
        this.addBtn.setOnMouseClicked(new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                DeviceTemplateListController.this.openPropertyView(MODE.CREATE);
            }
        });
        this.refreshBtn.setOnMouseClicked(new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                DeviceTemplateListController.this.refreshClicked();
            }
        });
        this.deleteBtn.setOnMouseClicked(new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                DeviceTemplateListController.this.deleteClicked();
            }
        });
        this.cloneBtn.setOnMouseClicked(new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                DeviceTemplateListController.this.openPropertyView(MODE.CLONE);
            }
        });
        this.editBtn.setOnMouseClicked(new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                DeviceTemplateListController.this.openPropertyView(MODE.MODIFY);
            }
        });
        this.listView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<DeviceTemplateData>(){

            public void changed(ObservableValue<? extends DeviceTemplateData> arg0, DeviceTemplateData arg1, DeviceTemplateData arg2) {
                if (arg2 == null) {
                    return;
                }
                DeviceTemplateListController.this.editBtn.setDisable(!arg2.isCustom());
                DeviceTemplateListController.this.deleteBtn.setDisable(!arg2.isCustom());
            }
        });
        this.refreshBtn.setTooltipText("refresh list");
        this.editBtn.setTooltipText("edit template");
        this.cloneBtn.setTooltipText("clone template");
        this.addBtn.setTooltipText("add new template");
        this.deleteBtn.setTooltipText("delete");
    }

    public void selectDefaultData(DeviceTemplate template) {
        if (this.listData.size() <= 0) {
            return;
        }
        if (template == null) {
            this.listView.getSelectionModel().selectFirst();
        } else {
            for (DeviceTemplateData data : this.listData) {
                if (!template.equals(data.getTemplate())) continue;
                this.listView.getSelectionModel().select((Object)data);
                return;
            }
            this.listView.getSelectionModel().selectFirst();
        }
    }

    public void setVMDialogData(VMDialogData dialogData) {
        this.dialogData = dialogData;
    }

    private void refreshClicked() {
        DeviceTemplateList.getDeviceTemplateList(true);
        this.listData.clear();
        this.makeDataList(this.platform);
        this.listView.getSelectionModel().selectFirst();
    }

    private void deleteClicked() {
        DeviceTemplateData data = (DeviceTemplateData)this.listView.getSelectionModel().getSelectedItem();
        if (data == null) {
            return;
        }
        if (data.getTemplate().getValue().isStandard()) {
            return;
        }
        ButtonType returnType = MessageBox.confirm("Are you sure you want to delete" + StringResources.NEW_LINE + "the selected device template?", new ButtonType("Delete", ButtonBar.ButtonData.OK_DONE));
        if (returnType == ButtonType.CANCEL) {
            return;
        }
        int index = this.listView.getSelectionModel().getSelectedIndex();
        DeviceTemplate template = data.getTemplate();
        try {
            template.delete();
            this.listData.remove(index);
            if (this.listData.size() > 0) {
                if (index == this.listData.size()) {
                    this.listView.getSelectionModel().select(index - 1);
                } else {
                    this.listView.getSelectionModel().select(index);
                }
            }
            DeviceTemplateList.removeTemplate(template);
        }
        catch (DeviceWorkerException e) {
            EMLogger.getLogger().warning(e.getMessage());
            MessageBox.error(e.getMessage());
        }
    }

    private void openPropertyView(MODE mode) {
        DeviceTemplateValue value;
        final DeviceTemplatePropertyView view = new DeviceTemplatePropertyView(mode);
        if (mode == MODE.CREATE) {
            Platform platform = this.dialogData.getPlatform();
            value = DeviceTemplateValue.createDefaultValue(platform.getProfile().getName());
            value.setSkinShape(platform.getImageSkinShape());
        } else {
            DeviceTemplateData templateData = (DeviceTemplateData)this.listView.getSelectionModel().selectedItemProperty().get();
            assert (templateData != null);
            value = templateData.getTemplate().getValue().clone();
        }
        view.setDeviceTemplateValue(value);
        view.createItems();
        view.setConfirmButtonClicked(new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                DeviceTemplateValue value = view.getValue();
                MODE mode = view.getMode();
                DeviceTemplateList.setTemplateSkin(value, DeviceTemplateListController.this.dialogData.getPlatform());
                if (mode == MODE.CREATE || mode == MODE.CLONE) {
                    DeviceTemplateListController.this.createDeviceTemplate(value);
                } else if (mode == MODE.MODIFY) {
                    DeviceTemplateListController.this.modifyDeviceTemplate(value);
                }
                view.closePropertyView();
            }
        });
        view.setCancelButtonClicked(new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                view.closePropertyView();
            }
        });
        view.openPropertyView("Template Configuration", 400, 540);
        view.getButtons().getButton(ButtonType.OK).requestFocus();
        view.setOnClosed(new EventHandler<WindowEvent>(){

            public void handle(WindowEvent arg0) {
                DeviceTemplateListController.this.addBtn.setSelected(false);
                DeviceTemplateListController.this.editBtn.setSelected(false);
                DeviceTemplateListController.this.cloneBtn.setSelected(false);
            }
        });
    }

    private void createDeviceTemplate(DeviceTemplateValue value) {
        if (value == null) {
            return;
        }
        value.setType(DeviceTemplateType.CUSTOM);
        value.setPriority(DeviceTemplatePriority.CUSTOM);
        DeviceTemplate template = new DeviceTemplate();
        try {
            template.create(value);
            DeviceTemplateData data = new DeviceTemplateData(template, this.platform.getVersion().toString());
            this.listData.add((Object)data);
            this.listView.getSelectionModel().select((Object)data);
            this.listView.scrollTo(this.listView.getSelectionModel().getSelectedIndex());
            DeviceTemplateList.addTemplate(template);
        }
        catch (DeviceWorkerException e) {
            EMLogger.getLogger().warning(e.getMessage());
            MessageBox.error(e.getMessage());
        }
    }

    private void modifyDeviceTemplate(DeviceTemplateValue value) {
        if (value == null) {
            return;
        }
        value.updateVersion();
        DeviceTemplateData templateData = (DeviceTemplateData)this.listView.getSelectionModel().selectedItemProperty().get();
        int index = this.listView.getSelectionModel().getSelectedIndex();
        try {
            DeviceTemplate template = templateData.getTemplate();
            template.modify(value);
            this.listData.remove(index);
            this.listData.add(index, (Object)new DeviceTemplateData(template, this.platform.getVersion().toString()));
            this.listView.getSelectionModel().select(index);
        }
        catch (DeviceWorkerException e) {
            EMLogger.getLogger().warning(e.getMessage());
            MessageBox.error(e.getMessage());
        }
    }

    public void makeDataList(Platform platform) {
        assert (platform != null);
        this.platform = platform;
        this.listData.clear();
        for (DeviceTemplate template : DeviceTemplateList.getDeviceTemplateListByPlatform(platform)) {
            this.listData.add((Object)new DeviceTemplateData(template, platform.getVersion().toString()));
        }
    }

    public Pane getRootPane() {
        return this.rootPane;
    }

    public DeviceTemplate getDeviceTemplate() {
        return ((DeviceTemplateData)this.listView.getSelectionModel().selectedItemProperty().get()).getTemplate();
    }
}

