/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.create;

import java.io.File;
import java.util.List;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import org.tizen.emulator.manager.devices.DeviceTemplateValue;
import org.tizen.emulator.manager.ui.controller.create.DeviceTemplateViewHelper;
import org.tizen.emulator.manager.ui.controller.create.PropertyView;
import org.tizen.emulator.manager.ui.item.TemplateValue;
import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.template.Template;
import org.tizen.emulator.manager.ui.template.TemplateLoader;
import org.tizen.emulator.manager.ui.template.item.Item;

public class DeviceTemplatePropertyView
extends PropertyView {
    List<ViewItemController> viewItems;
    DeviceTemplateValue deviceTemplateValue;
    String profile = null;
    List<ViewItemController> items;
    PropertyValue value;

    public DeviceTemplatePropertyView(MODE mode) {
        super(mode);
    }

    public void setDeviceTemplateValue(DeviceTemplateValue deviceTemplateValue) {
        this.deviceTemplateValue = deviceTemplateValue;
        this.profile = deviceTemplateValue.getProfile();
    }

    public void createItems() {
        Template template = TemplateLoader.loadTemplate(new File(DeviceTemplateViewHelper.getTemplatePath(this.profile)));
        List<Item> itemList = DeviceTemplateViewHelper.getDeviceTemplateItemList(template);
        this.items = DeviceTemplateViewHelper.getViewItemList(itemList);
        this.value = new TemplateValue(this.deviceTemplateValue);
        VBox vBox = new VBox();
        vBox.setPadding(new Insets(23.0, 5.0, 20.0, 20.0));
        vBox.setAlignment(Pos.TOP_LEFT);
        ScrollPane sc = this.controller.getScrollPane();
        sc.setContent((Node)vBox);
        sc.setFitToWidth(true);
        for (ViewItemController i : this.items) {
            i.setMode(this.getMode());
            i.setIntializeValue(this.value);
            Pane pane = i.getViewItem().getContent();
            i.getViewItem().setTitleMinWidth(88.0);
            vBox.getChildren().add((Object)pane);
            vBox.setSpacing(10.0);
        }
    }

    public DeviceTemplateValue getValue() {
        for (ViewItemController view : this.items) {
            view.setPropertyValue(this.value);
        }
        return (DeviceTemplateValue)this.value.getData();
    }
}

