/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.resources;

import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.ui.resources.FontSupplier;
import org.tizen.emulator.manager.ui.resources.ResourceKind;
import org.tizen.emulator.manager.ui.resources.Supplier;

public class FontKind
implements ResourceKind {
    public static FontKind TITLE_FONT_BOLD_37 = new FontKind(new FontSupplier("BreezeSans-Bold", 37.0), new Supplier<Font>(){

        @Override
        public Font get() {
            return Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)38.0);
        }
    }, new FontSupplier("BreezeSans-Bold", 37.0));
    public static FontKind TITLE_FONT_BOLD_25 = new FontKind(new FontSupplier("BreezeSans-Bold", 25.0), new Supplier<Font>(){

        @Override
        public Font get() {
            return Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)26.0);
        }
    }, new FontSupplier("BreezeSans-Bold", 25.0));
    public static FontKind TITLE_FONT_13 = new FontKind(new FontSupplier("BreezeSans", 13.0), new Supplier<Font>(){

        @Override
        public Font get() {
            return Font.font((String)"Arial", (FontWeight)FontWeight.NORMAL, (double)14.0);
        }
    }, new FontSupplier("BreezeSans", 13.0));
    private Supplier<Font> linuxSupplier;
    private Supplier<Font> winSupplier;
    private Supplier<Font> macSupplier;

    public FontKind(Supplier<Font> supplier) {
        this.linuxSupplier = supplier;
        this.winSupplier = supplier;
        this.macSupplier = supplier;
    }

    public FontKind(Supplier<Font> linuxSupplier, Supplier<Font> winSupplier, Supplier<Font> macSupplier) {
        this.linuxSupplier = linuxSupplier;
        this.winSupplier = winSupplier;
        this.macSupplier = macSupplier;
    }

    public Supplier<Font> getSupplier() {
        if (OSUtil.isMac()) {
            return this.macSupplier;
        }
        if (OSUtil.isWin()) {
            return this.winSupplier;
        }
        return this.linuxSupplier;
    }
}

