/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.devicetemplate.controller;

import java.io.File;
import java.io.IOException;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.platform.Skin;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.STATE;
import org.tizen.emulator.manager.ui.tabview.controller.FileViewController;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.tabview.item.FileViewItem;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;
import org.tizen.emulator.manager.ui.template.item.Item;

public class SkinViewController
extends FileViewController {
    private Skin skin;

    public SkinViewController(Item item) {
        super(item);
    }

    @Override
    public void setViewItem(ViewItem item) {
        this.fileType = FileViewItem.Type.DIR;
        super.setViewItem(item);
        this.fileItem.setInitialDirectory(FilePathResources.getTizenSDKPath());
        this.fileItem.addEventHandler(EventType.Selection, new EventHandler<Event>(){

            @Override
            public void handleEvent(Event event) {
                String path = SkinViewController.this.fileItem.getFilePath();
                if (new File(path).exists()) {
                    SkinViewController.this.fileItem.setInitialDirectory(path);
                }
                SkinViewController.this.checkValid();
            }
        });
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        String path;
        this.skin = (Skin)value.getObjectValue(this.getName());
        String string = path = this.skin == null ? null : this.skin.getPath();
        if (path == null || path.isEmpty()) {
            this.fileItem.setFile(null);
        } else {
            this.fileItem.setFile(new File(path));
        }
        if (this.skin != null && new File(this.skin.getPath()).exists()) {
            this.fileItem.setInitialDirectory(this.skin.getPath());
        }
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        if (this.skin != null) {
            value.setObjectValue(this.getName(), this.skin);
        }
    }

    @Override
    public void checkValid() {
        this.makeSkin(this.fileItem.getSelectedFile());
        if (this.skin == null) {
            this.setState(STATE.WARNING);
            this.fileItem.setState(STATE.WARNING, "Fail to load skin.");
        } else {
            this.setState(STATE.OK);
            this.fileItem.setState(STATE.OK, "");
        }
    }

    private void makeSkin(File path) {
        if (path == null) {
            return;
        }
        try {
            this.skin = new Skin(path);
        }
        catch (IOException e) {
            String error = "Failed to create skin resource." + StringResources.NEW_LINE + e.getMessage();
            EMLogger.getLogger().info(error);
            this.skin = null;
        }
        if (this.skin == null) {
            return;
        }
        if (this.getMode() == MODE.MODIFY) {
            ItemEvent iEvent = new ItemEvent(this.getName());
            iEvent.data = this.skin;
            ViewItemController.sendChangeEvent(iEvent);
        }
    }
}

