/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.network;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.network.EthernetTCPIP;
import org.tizen.emulator.manager.network.NetworkUtil;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.vms.exception.VMLauncherException;
import org.tizen.emulator.manager.vms.exception.VMWorkerException;
import org.tizen.emulator.manager.vms.helper.HelperClass;
import org.tizen.emulator.manager.vms.helper.ProcessResult;

public class WindowsBridge {
    private static int isDhcp = 0;
    private static String IF_OPER_STATUS_UP = "1";
    private static String BRIDGE_OPTION = "--bridge";
    private static String NETSH = "netsh.exe";
    private static String BRIDGEINF = "c:\\windows\\inf\\netbrdgm.inf";
    private static String bridgeClassId = null;
    static long WAIT_TIME = 1000L;
    static long MAX_TRY = 180L;
    private static EthernetTCPIP ethernet = new EthernetTCPIP();

    public static void create() throws VMWorkerException {
        EMLogger.getLogger().info("create bridge");
        List<String> cmd = Arrays.asList(FilePathResources.getDevconPath(), "install", BRIDGEINF, "ms_bridgemp");
        ProcessResult res = HelperClass.runProcess(cmd);
        if (!res.isSuccess()) {
            throw new VMWorkerException(res.getResultMessage());
        }
        bridgeClassId = null;
    }

    public static String getCompatibleID(String ifName) {
        EMLogger.getLogger().info("get CompatibleIDs from pci network device");
        List<String> cmd = Arrays.asList(FilePathResources.getDevconPath(), "find", "=net", "@pci*");
        ProcessResult res = HelperClass.runProcess(cmd);
        boolean isCommandSuccess = false;
        String CompatibleID = null;
        if (res.isSuccess()) {
            for (String str : res.getStdOutMsg()) {
                if (!str.endsWith(ifName)) continue;
                isCommandSuccess = true;
                CompatibleID = str.split(":")[0].trim();
                EMLogger.getLogger().info("CompatibleIDs for Ethernet device: " + CompatibleID);
                break;
            }
        } else if (!res.isSuccess() || !isCommandSuccess) {
            EMLogger.getLogger().warning(res.getResultMessage());
        }
        EMLogger.getLogger().info("CompatibleID of " + ifName + ": " + CompatibleID);
        return CompatibleID;
    }

    public static void checkEthernet(String ifName, String compatibleID) throws VMWorkerException {
        EMLogger.getLogger().info("bind interface to bridge");
        List<String> cmd = Arrays.asList(FilePathResources.getToolEmulatorBinPath() + File.separator + "bindbridge.exe", "ms_bridge", compatibleID, "check");
        ProcessResult res = HelperClass.runProcess(cmd);
        if (!res.isSuccess()) {
            throw new VMWorkerException(res.getResultMessage());
        }
    }

    public static String bindEthernet(String ifName, String compatibleID) throws VMWorkerException {
        if (!WindowsBridge.isExist()) {
            throw new VMWorkerException("Network Bridge does not exist.");
        }
        EMLogger.getLogger().info("bind interface to bridge");
        List<String> cmd = Arrays.asList(FilePathResources.getToolEmulatorBinPath() + File.separator + "bindbridge.exe", "ms_bridge", compatibleID, "bind");
        ProcessResult res = HelperClass.runProcess(cmd);
        if (!res.isSuccess()) {
            throw new VMWorkerException(res.getResultMessage());
        }
        return compatibleID;
    }

    public static void bindTap(String tapName) throws VMWorkerException {
        boolean isTapExist = false;
        isTapExist = NetworkUtil.isTapExist(tapName);
        if (!isTapExist) {
            throw new VMWorkerException(tapName + " does not exist.");
        }
        EMLogger.getLogger().info("bind host network to bridge");
        String tapPnpInstanceID = NetworkUtil.getPnpInstanceIDFromName(tapName);
        List<String> cmd = Arrays.asList(FilePathResources.getToolEmulatorBinPath() + File.separator + "bindbridge.exe", "ms_bridge", tapPnpInstanceID, "bind");
        ProcessResult res = HelperClass.runProcess(cmd);
        if (!res.isSuccess()) {
            throw new VMWorkerException(res.getResultMessage());
        }
        EMLogger.getLogger().info("wait while finishing bridged network setting");
        cmd = Arrays.asList(FilePathResources.getCheckNetPath(), NetworkUtil.BRIDGE_OPTION);
        res = HelperClass.runProcess(cmd);
        while (!res.getStdOutMsg().isEmpty()) {
            boolean isCommandSuccess = false;
            String ipAddr = null;
            if (res.isSuccess()) {
                for (String str : res.getStdOutMsg()) {
                    if (!str.startsWith("IP Address:")) continue;
                    isCommandSuccess = true;
                    ipAddr = str.split("IP Address: ")[1].trim();
                    EMLogger.getLogger().info("bridge IP address: " + ipAddr);
                    break;
                }
            } else if (!res.isSuccess() || !isCommandSuccess) {
                EMLogger.getLogger().warning(res.getResultMessage());
            }
            if (ipAddr != null) break;
            res = HelperClass.runProcess(cmd);
        }
    }

    static String getClassId() {
        EMLogger.getLogger().info("get class id for Network bridge.");
        if (bridgeClassId != null) {
            return bridgeClassId;
        }
        List<String> cmd = Arrays.asList(FilePathResources.getCheckNetPath(), BRIDGE_OPTION);
        ProcessResult res = HelperClass.runProcess(cmd);
        boolean isCommandSuccess = false;
        if (res.isSuccess()) {
            for (String str : res.getStdOutMsg()) {
                if (!str.startsWith("ClassID:")) continue;
                String[] arr = str.split(": ");
                bridgeClassId = arr[arr.length - 1];
                break;
            }
        } else if (!res.isSuccess() || !isCommandSuccess) {
            EMLogger.getLogger().warning(res.getResultMessage());
        }
        if (bridgeClassId == null) {
            EMLogger.getLogger().warning("cannot get bridgeId from:" + cmd);
            EMLogger.getLogger().warning("find from registry");
            WinReg.HKEY root = WinReg.HKEY_LOCAL_MACHINE;
            String topKey = "SYSTEM\\CurrentControlSet\\services\\BridgeMP";
            String value = "Device";
            try {
                String data = Advapi32Util.registryGetStringValue((WinReg.HKEY)root, (String)topKey, (String)value);
                if (data != null) {
                    String[] arr = data.split("\\\\");
                    bridgeClassId = arr[arr.length - 1];
                }
            }
            catch (Win32Exception e) {
                EMLogger.getLogger().warning("Failed to bridge's class id: " + e.getMessage());
            }
        }
        EMLogger.getLogger().info("bridgeId: " + bridgeClassId);
        return bridgeClassId;
    }

    public static boolean isWork() throws VMLauncherException {
        boolean isOperating = false;
        String OPERATING_STATUS = "Operating Status:";
        List<String> cmd = Arrays.asList(FilePathResources.getCheckNetPath(), BRIDGE_OPTION);
        ProcessResult res = HelperClass.runProcess(cmd);
        if (!res.isSuccess()) {
            throw new VMLauncherException(res.getResultMessage());
        }
        for (String str : res.getStdOutMsg()) {
            if (!str.startsWith(OPERATING_STATUS)) continue;
            String operStatus = str.split(OPERATING_STATUS)[1].trim();
            EMLogger.getLogger().info(OPERATING_STATUS + operStatus);
            if (!operStatus.equals(IF_OPER_STATUS_UP)) break;
            isOperating = true;
            break;
        }
        return isOperating;
    }

    public static boolean isReady() throws VMLauncherException {
        boolean isAvailable = false;
        String desc = "Adapter Desc:";
        List<String> cmd = Arrays.asList(FilePathResources.getCheckNetPath(), BRIDGE_OPTION);
        ProcessResult res = HelperClass.runProcess(cmd);
        if (!res.isSuccess()) {
            throw new VMLauncherException(res.getResultMessage());
        }
        for (String str : res.getStdOutMsg()) {
            if (!str.startsWith(desc)) continue;
            isAvailable = true;
            break;
        }
        return isAvailable;
    }

    public static boolean isExist() {
        boolean isExist = false;
        List<String> cmd = Arrays.asList(FilePathResources.getCheckNetPath(), BRIDGE_OPTION);
        ProcessResult res = HelperClass.runProcess(cmd);
        boolean isCommandSuccess = false;
        if (res.isSuccess()) {
            for (String str : res.getStdOutMsg()) {
                if (!str.startsWith("Adapter Desc:")) continue;
                isExist = true;
                isCommandSuccess = true;
                EMLogger.getLogger().info("Bridge exists: " + str);
                break;
            }
        } else if (!res.isSuccess() || !isCommandSuccess) {
            EMLogger.getLogger().warning(res.getResultMessage());
        }
        if (!isExist) {
            WinReg.HKEY root = WinReg.HKEY_LOCAL_MACHINE;
            String topKey = "SYSTEM\\CurrentControlSet\\services\\BridgeMP\\Enum";
            String value = "Count";
            try {
                int data = Advapi32Util.registryGetIntValue((WinReg.HKEY)root, (String)topKey, (String)value);
                if (data > 1) {
                    EMLogger.getLogger().info("bridge count: " + data);
                    return true;
                }
            }
            catch (Win32Exception e) {
                EMLogger.getLogger().warning("Failed to bridge's key(" + topKey + ")" + e.getMessage());
            }
        }
        return isExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDeviceFriendlyNameFromClassID(String classID) throws VMWorkerException {
        WinReg.HKEY root = WinReg.HKEY_LOCAL_MACHINE;
        String topKey = "SYSTEM\\CurrentControlSet\\Control\\Network\\{4D36E972-E325-11CE-BFC1-08002BE10318}\\" + classID + "\\Connection";
        String value = "Name";
        String friendlyName = "";
        WinReg.HKEYByReference regKey = null;
        try {
            regKey = Advapi32Util.registryGetKey((WinReg.HKEY)root, (String)topKey, (int)131097);
            friendlyName = Advapi32Util.registryGetStringValue((WinReg.HKEY)root, (String)topKey, (String)value);
        }
        catch (Win32Exception e) {
            EMLogger.getLogger().info(e.getMessage());
        }
        finally {
            if (regKey != null) {
                Advapi32Util.registryCloseKey((WinReg.HKEY)regKey.getValue());
            }
        }
        if (friendlyName == null || friendlyName.isEmpty()) {
            throw new VMWorkerException("Failed to create Network Bridge.");
        }
        return friendlyName;
    }

    static int getEthernetDhcp(WinReg.HKEY interfaceKey) {
        int isDhcp = Advapi32Util.registryGetIntValue((WinReg.HKEY)interfaceKey, (String)"EnableDHCP");
        EMLogger.getLogger().info("DHCP: " + isDhcp);
        return isDhcp;
    }

    public static boolean isDhcpOn() {
        return isDhcp == 1;
    }

    static WinReg.HKEY getTcpipKey() {
        WinReg.HKEY resultKey = null;
        String bridgeId = WindowsBridge.getClassId();
        if (bridgeId == null) {
            EMLogger.getLogger().warning("value is null");
            return resultKey;
        }
        WinReg.HKEY root = WinReg.HKEY_LOCAL_MACHINE;
        String topKey = "SYSTEM\\CurrentControlSet\\services\\Tcpip\\Parameters\\Interfaces\\";
        resultKey = Advapi32Util.registryGetKey((WinReg.HKEY)root, (String)(topKey + bridgeId), (int)131097).getValue();
        return resultKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void backupEthernetTCPIP(String interfaceClassID) throws VMWorkerException {
        EMLogger.getLogger().info("backup TCP/IP info");
        WinReg.HKEY interfaceKey = NetworkUtil.getInterfaceTcpipKey(interfaceClassID);
        EMLogger.getLogger().info("interfaceID: " + interfaceClassID);
        String ethernetName = WindowsBridge.getDeviceFriendlyNameFromClassID(interfaceClassID);
        String dns = null;
        String ip = null;
        String gateway = null;
        String netmask = null;
        if (interfaceKey != null) {
            try {
                int isDhcp = WindowsBridge.getEthernetDhcp(interfaceKey);
                if (isDhcp == 0) {
                    String[] ips = NetworkUtil.registryGetStringArray(interfaceKey, "IPAddress");
                    if (ips.length > 0) {
                        ip = ips[0];
                    }
                    EMLogger.getLogger().info("ip: " + ip);
                    String[] gateways = NetworkUtil.registryGetStringArray(interfaceKey, "DefaultGateway");
                    if (gateways.length > 0) {
                        gateway = gateways[0];
                    }
                    EMLogger.getLogger().info("gateway: " + gateway);
                    String[] netmasks = NetworkUtil.registryGetStringArray(interfaceKey, "SubnetMask");
                    if (netmasks.length > 0) {
                        netmask = netmasks[0];
                    }
                    EMLogger.getLogger().info("netmask: " + netmask);
                } else if (isDhcp == 1) {
                    String dhcpIp = null;
                    String dhcpGateway = null;
                    String dhcpNetmask = null;
                    dhcpIp = Advapi32Util.registryGetStringValue((WinReg.HKEY)interfaceKey, (String)"DhcpIPAddress");
                    EMLogger.getLogger().info("DHCP ip: " + dhcpIp);
                    String[] gateways = NetworkUtil.registryGetStringArray(interfaceKey, "DhcpDefaultGateway");
                    if (gateways.length > 0) {
                        dhcpGateway = gateways[0];
                    }
                    EMLogger.getLogger().info("DHCP gateway: " + dhcpGateway);
                    dhcpNetmask = Advapi32Util.registryGetStringValue((WinReg.HKEY)interfaceKey, (String)"DhcpSubnetMask");
                    EMLogger.getLogger().info("DHCP netmask: " + dhcpNetmask);
                    if (!(dhcpIp == null || dhcpIp.isEmpty() || dhcpNetmask == null || dhcpNetmask.isEmpty() || dhcpGateway == null || dhcpGateway.isEmpty())) {
                        EMLogger.getLogger().info("disable using DHCP");
                        List<String> cmd = Arrays.asList(NETSH, "-c", "int", "ipv4", "set", "address", "\"name=" + ethernetName + "\"", "source=static", "address=" + dhcpIp, "mask=" + dhcpNetmask, "gateway=" + dhcpGateway, "gwmetric=0");
                        ProcessResult res = HelperClass.runProcess(cmd);
                        if (!res.isSuccess()) {
                            EMLogger.getLogger().warning("Failed to configure TCP/IP: " + res.getResultMessage());
                        }
                        EMLogger.getLogger().info("delete DHCP ip address");
                        cmd = Arrays.asList(NETSH, "interface", "ipv4", "delete", "address", ethernetName, "addr=" + dhcpIp, "gateway=all");
                        res = HelperClass.runProcess(cmd);
                        if (!res.isSuccess()) {
                            EMLogger.getLogger().warning(res.getResultMessage());
                        }
                    }
                }
                String val = Advapi32Util.registryGetStringValue((WinReg.HKEY)interfaceKey, (String)"NameServer");
                String[] arr = val.split(",");
                if (arr.length > 0) {
                    dns = arr[0];
                }
                EMLogger.getLogger().info("NameServer: " + dns);
                ethernet.setTCPIP(isDhcp == 1, ip, gateway, netmask, dns);
            }
            catch (Win32Exception e) {
                EMLogger.getLogger().warning(e.getMessage());
            }
            finally {
                Advapi32Util.registryCloseKey((WinReg.HKEY)interfaceKey);
            }
        }
    }

    public static void setTcpip(String interfaceClassID) throws VMWorkerException {
        ProcessResult res;
        List<String> cmd;
        String dns = ethernet.getDns();
        String ip = ethernet.getIp();
        String gateway = ethernet.getGateway();
        String netmask = ethernet.getNetmask();
        boolean isDhcp = ethernet.isDhcpOn();
        String bridgeName = WindowsBridge.getDeviceFriendlyNameFromClassID(WindowsBridge.getClassId());
        EMLogger.getLogger().info("Bridge Name: " + bridgeName);
        if (!isDhcp) {
            if (ip != null && !ip.isEmpty()) {
                String ethernetName = WindowsBridge.getDeviceFriendlyNameFromClassID(interfaceClassID);
                EMLogger.getLogger().info("set ip to bridge network");
                if (netmask != null && !netmask.isEmpty() && gateway != null && !gateway.isEmpty()) {
                    block11: {
                        int tryConut = 0;
                        do {
                            try {
                                Thread.sleep(WAIT_TIME);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            if (WindowsBridge.isReady()) break block11;
                        } while ((long)(++tryConut) <= MAX_TRY);
                        throw new VMWorkerException("Failed to set Network Bridge's TCP/IP: timeout");
                    }
                    EMLogger.getLogger().info("delete ip address");
                    cmd = Arrays.asList(NETSH, "interface", "ipv4", "delete", "address", ethernetName, "addr=" + ip, "gateway=all");
                    res = HelperClass.runProcess(cmd);
                    if (!res.isSuccess()) {
                        EMLogger.getLogger().warning(res.getResultMessage());
                    }
                    EMLogger.getLogger().info("set TCP/IP to Network Bridge");
                    cmd = Arrays.asList(NETSH, "-c", "int", "ipv4", "set", "address", "\"name=" + bridgeName + "\"", "source=static", "address=" + ip, "mask=" + netmask, "gateway=" + gateway, "gwmetric=0");
                    res = HelperClass.runProcess(cmd);
                    if (!res.isSuccess()) {
                        EMLogger.getLogger().warning(res.getResultMessage());
                    }
                }
            }
        } else {
            cmd = Arrays.asList(NETSH, "-c", "int", "ipv4", "set", "address", "\"name=" + bridgeName + "\"", "dhcp");
            res = HelperClass.runProcess(cmd);
            if (!res.isSuccess()) {
                EMLogger.getLogger().warning("Failed to enable DHCP: " + res.getResultMessage());
            }
        }
        if (dns != null && !dns.isEmpty() && !(res = HelperClass.runProcess(cmd = Arrays.asList(NETSH, "interface", "ipv4", "set", "dnsservers", "\"name=" + bridgeName + "\"", "static", dns, "primary"))).isSuccess()) {
            EMLogger.getLogger().warning("Failed to set DNS server: " + res.getResultMessage());
        }
    }

    public static String getIpAddress() {
        String ipAddr = null;
        WinReg.HKEY key = NetworkUtil.getInterfaceTcpipKey(WindowsBridge.getClassId());
        if (key != null) {
            try {
                if (!WindowsBridge.isDhcpOn()) {
                    String[] data = Advapi32Util.registryGetStringArray((WinReg.HKEY)key, (String)"IPAddress");
                    if (data.length > 0) {
                        ipAddr = data[0];
                    }
                } else {
                    ipAddr = Advapi32Util.registryGetStringValue((WinReg.HKEY)key, (String)"DhcpIPAddress");
                }
            }
            catch (Win32Exception e) {
                EMLogger.getLogger().warning(e.getMessage());
            }
            finally {
                Advapi32Util.registryCloseKey((WinReg.HKEY)key);
            }
        }
        if (ipAddr == null) {
            EMLogger.getLogger().warning("Can't find host bridge IP");
            ipAddr = "";
        }
        return ipAddr;
    }
}

