/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.vms;

import com.sun.javafx.scene.control.skin.TableHeaderRow;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.tool.About;
import org.tizen.emulator.manager.ui.controller.vms.CheckBoxTableColumn;
import org.tizen.emulator.manager.ui.controller.vms.CreateHandler;
import org.tizen.emulator.manager.ui.controller.vms.TableSelectionListener;
import org.tizen.emulator.manager.ui.controller.vms.VMCheckBoxCell;
import org.tizen.emulator.manager.ui.controller.vms.VMCheckSelectEvent;
import org.tizen.emulator.manager.ui.controller.vms.VMDeviceCell;
import org.tizen.emulator.manager.ui.controller.vms.VMPlatformCell;
import org.tizen.emulator.manager.ui.controller.vms.VMResolutionCell;
import org.tizen.emulator.manager.ui.controller.vms.VMStatusCell;
import org.tizen.emulator.manager.ui.controller.vms.VMTableRow;
import org.tizen.emulator.manager.ui.controller.vms.filter.ColumnFilterEvent;
import org.tizen.emulator.manager.ui.controller.vms.filter.ProfileFilterTableColumn;
import org.tizen.emulator.manager.ui.dialog.ButtonType;
import org.tizen.emulator.manager.ui.dialog.Dialog;
import org.tizen.emulator.manager.ui.item.ModifyHandler;
import org.tizen.emulator.manager.ui.item.VMEventHandler;
import org.tizen.emulator.manager.ui.item.VMItem;
import org.tizen.emulator.manager.ui.resources.FontKind;
import org.tizen.emulator.manager.ui.resources.Fonts;
import org.tizen.emulator.manager.ui.resources.ImageKind;
import org.tizen.emulator.manager.ui.resources.Images;
import org.tizen.emulator.manager.vms.StateChangeListener;
import org.tizen.emulator.manager.vms.VMKeeper;
import org.tizen.emulator.manager.vms.VMProperty;

public class FXMLVMTableViewController
implements Initializable {
    private static double TABLE_DEFAULT_WIDTH = 644.0;
    @FXML
    private AnchorPane rootPane;
    @FXML
    private Label labTitle1;
    @FXML
    private Label labTitle2;
    @FXML
    private ImageView imgTitle;
    @FXML
    private Button btnCreate;
    @FXML
    private Button btnLaunch;
    @FXML
    private Button btnModify;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnAbout;
    @FXML
    private TableView<VMItem> vmTable;
    @FXML
    private TableColumn<VMItem, String> vmStatus;
    @FXML
    private ProfileFilterTableColumn<VMItem, String> vmType;
    @FXML
    private CheckBoxTableColumn<VMItem, Boolean> checkBox;
    @FXML
    private TableColumn<VMItem, String> vmName;
    @FXML
    private TableColumn<VMItem, String> vmPlatform;
    @FXML
    private TableColumn<VMItem, String> vmResolution;
    @FXML
    private TableColumn<VMItem, Integer> vmRAMSize;
    @FXML
    private TableColumn<VMItem, Integer> vmProcessors;
    @FXML
    private final ObservableList<VMItem> data = FXCollections.observableArrayList();
    @FXML
    private final ObservableList<VMItem> filteredData = FXCollections.observableArrayList();
    @FXML
    private ProgressIndicator progress;
    private List<String> filterList = new ArrayList<String>();
    private final Set<String> profileSet = new HashSet<String>();

    public void initialize(URL location, ResourceBundle resources) {
        this.intializeTable();
    }

    private void intializeTable() {
        this.labTitle1.setFont(Fonts.get(FontKind.FONT_21));
        this.labTitle2.setFont(Fonts.get(FontKind.FONT_38_BOLD));
        this.imgTitle.setImage(Images.get(ImageKind.TITLE_BG));
        this.btnLaunch.disableProperty().bindBidirectional((Property)TableSelectionListener.getDisableModify());
        this.btnDelete.disableProperty().bindBidirectional((Property)TableSelectionListener.getDisableDelete());
        this.btnModify.disableProperty().bindBidirectional((Property)TableSelectionListener.getDisableModify());
        this.btnCreate.setGraphic((Node)Images.getView(ImageKind.TOOL_CREATE_NOR));
        this.btnLaunch.setGraphic((Node)Images.getView(ImageKind.TOOL_LAUNCH_NOR));
        this.btnModify.setGraphic((Node)Images.getView(ImageKind.TOOL_EDIT_NOR));
        this.btnDelete.setGraphic((Node)Images.getView(ImageKind.TOOL_DELETE_NOR));
        this.btnAbout.setGraphic((Node)Images.getView(ImageKind.EM_INFO_NOR));
        GridPane.setMargin((Node)this.btnAbout, (Insets)new Insets(0.0, 20.0, 15.0, 0.0));
        this.btnLaunch.defaultButtonProperty().bind((ObservableValue)this.btnLaunch.focusedProperty());
        this.btnCreate.defaultButtonProperty().bind((ObservableValue)this.btnCreate.focusedProperty());
        this.btnDelete.defaultButtonProperty().bind((ObservableValue)this.btnDelete.focusedProperty());
        this.btnModify.defaultButtonProperty().bind((ObservableValue)this.btnModify.focusedProperty());
        this.btnAbout.setFocusTraversable(false);
        VMEventHandler.getIsVisible().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> value, Boolean oldValue, Boolean newValue) {
                if (newValue == null) {
                    return;
                }
                if (newValue.booleanValue()) {
                    FXMLVMTableViewController.this.progress.getParent().setVisible(true);
                    FXMLVMTableViewController.this.progress.setVisible(true);
                    EMLogger.getLogger().fine("Show progress indicator");
                } else {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            FXMLVMTableViewController.this.progress.getParent().setVisible(false);
                            FXMLVMTableViewController.this.progress.setVisible(false);
                            EMLogger.getLogger().fine("Hide progress indicator");
                        }
                    });
                }
            }
        });
        this.vmTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.vmTable.getSelectionModel().getSelectedIndices().addListener((ListChangeListener)new TableSelectionListener(this.vmTable));
        this.vmTable.setRowFactory(VMTableRow.extractor());
        this.vmTable.setPlaceholder((Node)new Label("No content in table"));
        this.vmTable.setItems(this.filteredData);
        this.vmTable.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> source, Number oldWidth, Number newWidth) {
                final TableHeaderRow row = (TableHeaderRow)FXMLVMTableViewController.this.vmTable.lookup("TableHeaderRow");
                row.reorderingProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                    public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                        row.setReordering(false);
                    }
                });
            }
        });
        this.checkBox.setCellValueFactory((Callback)new PropertyValueFactory("checked"));
        this.checkBox.setCellFactory(VMCheckBoxCell.extractor());
        this.vmType.setCellValueFactory((Callback)new PropertyValueFactory("type"));
        this.vmType.setCellFactory(VMDeviceCell.extractor());
        this.vmType.setMinWidth(80.0);
        this.vmType.prefWidthProperty().bind((ObservableValue)this.vmTable.widthProperty().multiply(135.0 / TABLE_DEFAULT_WIDTH));
        this.vmName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.vmName.setMinWidth(80.0);
        this.vmName.prefWidthProperty().bind((ObservableValue)this.vmTable.widthProperty().multiply(121.0 / TABLE_DEFAULT_WIDTH));
        this.vmPlatform.setCellValueFactory((Callback)new PropertyValueFactory("platform"));
        this.vmPlatform.setCellFactory(VMPlatformCell.extractor());
        this.vmPlatform.setMinWidth(80.0);
        this.vmPlatform.prefWidthProperty().bind((ObservableValue)this.vmTable.widthProperty().multiply(127.0 / TABLE_DEFAULT_WIDTH));
        this.vmResolution.setCellValueFactory((Callback)new PropertyValueFactory("resolution"));
        this.vmResolution.setCellFactory(VMResolutionCell.extractor());
        this.vmResolution.setMinWidth(90.0);
        this.vmResolution.prefWidthProperty().bind((ObservableValue)this.vmTable.widthProperty().multiply(132.0 / TABLE_DEFAULT_WIDTH));
        this.vmRAMSize.setCellValueFactory((Callback)new PropertyValueFactory("RAMSize"));
        this.vmProcessors.setCellValueFactory((Callback)new PropertyValueFactory("processors"));
        this.vmStatus.setCellValueFactory((Callback)new PropertyValueFactory("status"));
        this.vmStatus.setCellFactory(VMStatusCell.extractor());
        this.vmStatus.prefWidthProperty().bind((ObservableValue)this.vmTable.widthProperty().multiply(70.0 / TABLE_DEFAULT_WIDTH));
        this.addVMListener();
        this.vmTable.addEventHandler(ColumnFilterEvent.FILTER_CHANGED_EVENT, (EventHandler)new EventHandler<ColumnFilterEvent>(){

            public void handle(ColumnFilterEvent e) {
                FXMLVMTableViewController.this.filterList = e.getFilters();
                FXMLVMTableViewController.this.setFilterPopupValue();
                FXMLVMTableViewController.this.applyFilter(true);
                boolean isFilterWorking = false;
                for (String profile : FXMLVMTableViewController.this.profileSet) {
                    if (FXMLVMTableViewController.this.filterList.contains(profile)) continue;
                    isFilterWorking = true;
                    break;
                }
                e.getFilterButton().changeIcon(isFilterWorking);
            }
        });
        this.vmTable.addEventHandler(VMCheckSelectEvent.VM_CHECK_SELECTED, (EventHandler)new EventHandler<VMCheckSelectEvent>(){

            public void handle(VMCheckSelectEvent arg0) {
                if (FXMLVMTableViewController.this.vmTable.getItems().size() < 1) {
                    return;
                }
                if (arg0.isChecked()) {
                    FXMLVMTableViewController.this.vmTable.getSelectionModel().selectAll();
                } else {
                    FXMLVMTableViewController.this.vmTable.getSelectionModel().clearSelection();
                }
            }
        });
        this.vmTable.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                KeyCode keyCode = event.getCode();
                switch (keyCode) {
                    case ENTER: {
                        if (TableSelectionListener.getDisableModify().get()) break;
                        VMEventHandler.launch(FXMLVMTableViewController.this.getSelectedItem());
                        break;
                    }
                    case DELETE: {
                        if (TableSelectionListener.getDisableDelete().get()) break;
                        VMEventHandler.delete(FXMLVMTableViewController.this.getSelectedItems());
                        break;
                    }
                }
            }
        });
    }

    private boolean containsVMItem(VMItem vmItem, ObservableList<VMItem> list) {
        for (VMItem item : list) {
            if (!item.getName().equals(vmItem.getName())) continue;
            return true;
        }
        return false;
    }

    private void applyFilter(boolean resetSelection) {
        int selectIndex = resetSelection ? 0 : this.vmTable.getSelectionModel().getSelectedIndex();
        for (VMItem item : this.data) {
            if (!this.filterList.contains(item.getProfile()) || this.containsVMItem(item, this.filteredData)) continue;
            this.filteredData.add(0, (Object)item);
        }
        ArrayList<VMItem> removeItem = new ArrayList<VMItem>();
        for (VMItem item : this.filteredData) {
            if (this.filterList.contains(item.getProfile()) && this.containsVMItem(item, this.data)) continue;
            removeItem.add(item);
        }
        this.filteredData.removeAll(removeItem);
        this.vmTable.getSelectionModel().clearSelection();
        CheckBoxTableColumn.checkCountProperty().set(0);
        if (selectIndex >= this.vmTable.getItems().size()) {
            selectIndex = this.vmTable.getItems().size() - 1;
        }
        this.vmTable.getSelectionModel().clearAndSelect(selectIndex);
    }

    private void checkProfileList(String profile, boolean isAdd) {
        if (isAdd) {
            if (!this.profileSet.contains(profile)) {
                this.profileSet.add(profile);
                this.filterList.add(profile);
            }
        } else {
            this.profileSet.remove(profile);
            for (VMItem item : this.data) {
                this.profileSet.add(item.getProfile());
            }
            if (!this.profileSet.contains(profile)) {
                this.filterList.remove(profile);
            }
        }
        this.setFilterPopupValue();
    }

    private void setFilterPopupValue() {
        HashMap<String, Boolean> filterValue = new HashMap<String, Boolean>();
        for (String p : this.profileSet) {
            filterValue.put(p, this.filterList.contains(p));
        }
        this.vmType.setFilterValue(filterValue);
    }

    private void addVMListener() {
        VMKeeper.addListChangeListener(new org.tizen.emulator.manager.vms.ListChangeListener<VMProperty>(){

            @Override
            public void elementAdded(final VMProperty property) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        EMLogger.getLogger().fine("Create property: " + property.getPropertyValue().vmName);
                        FXMLVMTableViewController.this.data.add(0, (Object)new VMItem(property));
                        FXMLVMTableViewController.this.checkProfileList(property.getPropertyValue().getProfile(), true);
                        FXMLVMTableViewController.this.applyFilter(true);
                    }
                });
            }

            @Override
            public void elementRemoved(final VMProperty property) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        String vmName = property.getPropertyValue().vmName;
                        EMLogger.getLogger().fine("Delete property: " + vmName);
                        for (int i = 0; i < FXMLVMTableViewController.this.data.size(); ++i) {
                            VMItem item = (VMItem)FXMLVMTableViewController.this.data.get(i);
                            if (!item.getName().equals(vmName)) continue;
                            FXMLVMTableViewController.this.data.remove(i);
                            break;
                        }
                        FXMLVMTableViewController.this.checkProfileList(property.getPropertyValue().getProfile(), false);
                        FXMLVMTableViewController.this.applyFilter(false);
                    }
                });
            }

            @Override
            public void elementModified(final VMProperty property) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        String vmName = property.getPropertyValue().vmName;
                        EMLogger.getLogger().fine("Modify property: " + vmName);
                        for (VMItem item : FXMLVMTableViewController.this.data) {
                            if (!item.getName().equals(vmName)) continue;
                            item.setValue(property);
                            break;
                        }
                        FXMLVMTableViewController.this.applyFilter(false);
                    }
                });
            }
        });
        VMProperty.addStateChangeListener(new StateChangeListener<VMProperty>(){

            @Override
            public void stateChanged(final VMProperty property) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        String vmName = property.getPropertyValue().vmName;
                        EMLogger.getLogger().fine("Change status of property: " + property.getPropertyValue().vmName + "(" + (Object)((Object)property.getState()) + ")");
                        ObservableList data = FXMLVMTableViewController.this.vmTable.getItems();
                        for (VMItem item : data) {
                            if (!item.getName().equals(vmName)) continue;
                            item.setStatus(property.getState().name());
                            break;
                        }
                        FXMLVMTableViewController.this.applyFilter(false);
                    }
                });
            }
        });
        VMProperty.addHealthChangeListener(new StateChangeListener<VMProperty>(){

            @Override
            public void stateChanged(final VMProperty property) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        String vmName = property.getPropertyValue().vmName;
                        EMLogger.getLogger().fine("Change status of property: " + property.getPropertyValue().vmName + "(" + (Object)((Object)property.getHealth()) + ")");
                        ObservableList data = FXMLVMTableViewController.this.vmTable.getItems();
                        for (VMItem item : data) {
                            if (!item.getName().equals(vmName)) continue;
                            item.setStatus(property.getHealth().name());
                            break;
                        }
                        FXMLVMTableViewController.this.applyFilter(false);
                    }
                });
            }
        });
    }

    @FXML
    public void createButtonMouseEvent(MouseEvent event) {
        if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
            this.btnCreate.setGraphic((Node)Images.getView(ImageKind.TOOL_CREATE_PRESS));
        } else if (event.getEventType() == MouseEvent.MOUSE_ENTERED) {
            this.btnCreate.setGraphic((Node)Images.getView(ImageKind.TOOL_CREATE_OVER));
        } else {
            this.btnCreate.setGraphic((Node)Images.getView(ImageKind.TOOL_CREATE_NOR));
        }
    }

    @FXML
    public void launchButtonMouseEvent(MouseEvent event) {
        if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
            this.btnLaunch.setGraphic((Node)Images.getView(ImageKind.TOOL_LAUNCH_PRESS));
        } else if (event.getEventType() == MouseEvent.MOUSE_ENTERED) {
            this.btnLaunch.setGraphic((Node)Images.getView(ImageKind.TOOL_LAUNCH_OVER));
        } else {
            this.btnLaunch.setGraphic((Node)Images.getView(ImageKind.TOOL_LAUNCH_NOR));
        }
    }

    @FXML
    public void modifyButtonMouseEvent(MouseEvent event) {
        if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
            this.btnModify.setGraphic((Node)Images.getView(ImageKind.TOOL_EDIT_PRESS));
        } else if (event.getEventType() == MouseEvent.MOUSE_ENTERED) {
            this.btnModify.setGraphic((Node)Images.getView(ImageKind.TOOL_EDIT_OVER));
        } else {
            this.btnModify.setGraphic((Node)Images.getView(ImageKind.TOOL_EDIT_NOR));
        }
    }

    @FXML
    public void deleteButtonMouseEvent(MouseEvent event) {
        if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
            this.btnDelete.setGraphic((Node)Images.getView(ImageKind.TOOL_DELETE_PRESS));
        } else if (event.getEventType() == MouseEvent.MOUSE_ENTERED) {
            this.btnDelete.setGraphic((Node)Images.getView(ImageKind.TOOL_DELETE_OVER));
        } else {
            this.btnDelete.setGraphic((Node)Images.getView(ImageKind.TOOL_DELETE_NOR));
        }
    }

    @FXML
    public void aboutButtonMouseEvent(MouseEvent event) {
        if (event.getEventType() == MouseEvent.MOUSE_ENTERED) {
            this.btnAbout.setGraphic((Node)Images.getView(ImageKind.EM_INFO_OVER));
        } else if (event.getEventType() == MouseEvent.MOUSE_CLICKED) {
            this.btnAbout.setGraphic((Node)Images.getView(ImageKind.EM_INFO_PRESS));
        } else {
            this.btnAbout.setGraphic((Node)Images.getView(ImageKind.EM_INFO_NOR));
        }
    }

    @FXML
    public void clickCreateButton(ActionEvent event) {
        EMLogger.getLogger().fine("Click create button");
        CreateHandler.create();
    }

    @FXML
    public void clickModifyButton(ActionEvent event) {
        EMLogger.getLogger().fine("Click modify button");
        ModifyHandler.modify(this.getSelectedItem());
    }

    @FXML
    public void clickLaunchButton(ActionEvent event) {
        EMLogger.getLogger().fine("Click launch button");
        VMEventHandler.launch(this.getSelectedItem());
    }

    @FXML
    public void clickDeleteButton(ActionEvent event) {
        EMLogger.getLogger().fine("Click delete button");
        VMEventHandler.delete(this.getSelectedItems());
    }

    @FXML
    public void clickAboutButton(ActionEvent event) {
        Dialog dialog = new Dialog();
        dialog.setTitle("About Emulator Manager");
        dialog.addButonType(ButtonType.CLOSE);
        VBox content = null;
        try {
            content = (VBox)FXMLLoader.load((URL)this.getClass().getResource("/view/AboutView.fxml"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (content == null) {
            About about = About.getInstance();
            String contents = "Version: " + about.getAboutVersion() + StringResources.NEW_LINE + "Build time: " + about.getBuildTime() + " (GMT)" + StringResources.NEW_LINE + "Git version: " + about.getGitVersion() + StringResources.NEW_LINE + "Workspace path: " + about.getWorkspacePath() + StringResources.NEW_LINE + "Package version: " + about.getPackageVersion();
            dialog.setContentText(contents);
        } else {
            AnchorPane pane = new AnchorPane();
            pane.getChildren().add((Object)content);
            AnchorPane.setLeftAnchor((Node)content, (Double)-1.0);
            AnchorPane.setRightAnchor((Node)content, (Double)-1.0);
            AnchorPane.setTopAnchor((Node)content, (Double)-1.0);
            dialog.getDialogPane().setContent((Node)pane);
            content.autosize();
        }
        dialog.getDialogPane().getButton(ButtonType.CLOSE).requestFocus();
        dialog.setResizable(false);
        dialog.show();
    }

    private VMItem getSelectedItem() {
        List<VMItem> items = this.getSelectedItems();
        if (items.isEmpty()) {
            return null;
        }
        return items.get(0);
    }

    private List<VMItem> getSelectedItems() {
        ArrayList<VMItem> items = new ArrayList<VMItem>();
        for (int i = 0; i < this.vmTable.getItems().size(); ++i) {
            if (!this.vmTable.getSelectionModel().isSelected(i)) continue;
            items.add((VMItem)this.vmTable.getItems().get(i));
        }
        if (items.isEmpty()) {
            EMLogger.getLogger().warning("Selected item list is empty...");
        }
        return items;
    }
}

