/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.controller;

import java.util.Map;
import org.tizen.emulator.manager.ui.Messages;
import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.STATE;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.tabview.item.NetProxyViewItem;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;
import org.tizen.emulator.manager.ui.template.TemplateUtil;
import org.tizen.emulator.manager.ui.template.item.Item;

public class NetProxyItemController
extends ViewItemController {
    private NetProxyViewItem viewItem;
    private String proxyMode = "";
    private Map<String, String> optionMap = null;
    private static int MAX_PORT = 65535;

    public NetProxyItemController(Item item) {
        super(item);
    }

    @Override
    public void makeViewItem() {
        this.setViewItem(new NetProxyViewItem());
    }

    @Override
    public ViewItem getViewItem() {
        return this.viewItem;
    }

    @Override
    public void setViewItem(ViewItem item) {
        this.viewItem = item instanceof NetProxyViewItem ? (NetProxyViewItem)item : new NetProxyViewItem();
        this.viewItem.setTitle(this.getTitle());
        this.initComboList();
        this.addListener();
    }

    private void addListener() {
        this.viewItem.addEventHandler(EventType.Selection, new EventHandler<Event>(){

            @Override
            public void handleEvent(Event event) {
                NetProxyItemController.this.onChangedValue(event);
            }
        });
        this.viewItem.addEventHandler(EventType.Modify, new EventHandler<Event>(){

            @Override
            public void handleEvent(Event event) {
                NetProxyItemController.this.onChangedValue(event);
            }
        });
    }

    private void initComboList() {
        this.optionMap = TemplateUtil.getProxyItemMap(this.item.getOptions());
        if (this.optionMap.get("auto") != null) {
            this.viewItem.addItem(this.optionMap.get("auto"), "auto");
        }
        if (this.optionMap.get("manual") != null) {
            this.viewItem.addItem(this.optionMap.get("manual"), "manual");
        }
        if (this.optionMap.get("none") != null) {
            this.viewItem.addItem(this.optionMap.get("none"), "none");
        }
        if (this.mode == MODE.CREATE) {
            this.proxyMode = "auto";
        }
    }

    @Override
    protected void onChangedValue(Event event) {
        if (event.type == EventType.Selection) {
            this.proxyMode = (String)event.data;
            this.viewItem.showSetting(this.proxyMode.equals("manual"));
        }
        this.checkValid();
        ItemEvent iEvent = new ItemEvent(this.getName(), this);
        NetProxyItemController.sendChangeEvent(iEvent);
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        String mode = value.getSubItemStringValue(this.getName(), "proxyMode");
        this.proxyMode = mode == null || mode.isEmpty() ? "auto" : mode;
        if (this.proxyMode.equals("manual")) {
            String http = value.getSubItemStringValue(this.getName(), "httpProxy");
            String https = value.getSubItemStringValue(this.getName(), "httpsProxy");
            String ftp = value.getSubItemStringValue(this.getName(), "ftpProxy");
            String socks = value.getSubItemStringValue(this.getName(), "socksProxy");
            int idx = http.lastIndexOf(":");
            if (idx > 0) {
                this.viewItem.setHttpProxy(http.substring(0, idx), http.substring(idx + 1, http.length()));
            }
            if (http.equals(https) && http.equals(ftp) && http.equals(socks)) {
                this.viewItem.setCheckUseHTTP(true);
            } else {
                idx = https.lastIndexOf(":");
                if (idx > 0) {
                    this.viewItem.setHttpsProxy(https.substring(0, idx), https.substring(idx + 1, https.length()));
                }
                if ((idx = ftp.lastIndexOf(":")) > 0) {
                    this.viewItem.setFtpProxy(ftp.substring(0, idx), ftp.substring(idx + 1, ftp.length()));
                }
                if ((idx = socks.lastIndexOf(":")) > 0) {
                    this.viewItem.setSocksProxy(socks.substring(0, idx), socks.substring(idx + 1, socks.length()));
                }
            }
        }
        this.viewItem.selectItem(this.optionMap.get(this.proxyMode));
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        value.setSubItemStringValue(this.getName(), "proxyMode", this.proxyMode);
        if (!this.proxyMode.equals("manual")) {
            value.setSubItemStringValue(this.getName(), "httpProxy", "");
            value.setSubItemStringValue(this.getName(), "httpsProxy", "");
            value.setSubItemStringValue(this.getName(), "ftpProxy", "");
            value.setSubItemStringValue(this.getName(), "socksProxy", "");
        } else {
            String proxy = this.viewItem.getHttp() + ":" + this.viewItem.getHttpPort();
            value.setSubItemStringValue(this.getName(), "httpProxy", proxy);
            if (this.viewItem.isUseHTTP()) {
                value.setSubItemStringValue(this.getName(), "httpsProxy", proxy);
                value.setSubItemStringValue(this.getName(), "ftpProxy", proxy);
                value.setSubItemStringValue(this.getName(), "socksProxy", proxy);
            } else {
                value.setSubItemStringValue(this.getName(), "httpsProxy", this.viewItem.getHttps() + ":" + this.viewItem.getHttpPort());
                value.setSubItemStringValue(this.getName(), "ftpProxy", this.viewItem.getFtp() + ":" + this.viewItem.getFtpPort());
                value.setSubItemStringValue(this.getName(), "socksProxy", this.viewItem.getSocks() + ":" + this.viewItem.getSocksPort());
            }
        }
    }

    @Override
    public void checkValid() {
        String msg = "";
        STATE newState = STATE.OK;
        if (this.proxyMode != null && this.proxyMode.equals("manual")) {
            if (this.viewItem.getHttp().isEmpty() || this.viewItem.getHttpPort().isEmpty() || this.viewItem.getHttpPort().equals("0") || Integer.valueOf(this.viewItem.getHttpPort()) > MAX_PORT) {
                msg = Messages.getString("NetProxyViewItem.ProxyError.0");
                newState = STATE.ERROR;
            }
            if (!this.viewItem.isUseHTTP()) {
                if (this.viewItem.getHttps().isEmpty() || this.viewItem.getHttpsPort().isEmpty() || this.viewItem.getHttpsPort().equals("0") || Integer.valueOf(this.viewItem.getHttpsPort()) > MAX_PORT) {
                    msg = Messages.getString("NetProxyViewItem.ProxyError.0");
                    newState = STATE.ERROR;
                } else if (this.viewItem.getFtp().isEmpty() || this.viewItem.getFtpPort().isEmpty() || this.viewItem.getFtpPort().equals("0") || Integer.valueOf(this.viewItem.getFtpPort()) > MAX_PORT) {
                    msg = Messages.getString("NetProxyViewItem.ProxyError.0");
                    newState = STATE.ERROR;
                } else if (this.viewItem.getSocks().isEmpty() || this.viewItem.getSocksPort().isEmpty() || this.viewItem.getSocksPort().equals("0") || Integer.valueOf(this.viewItem.getSocksPort()) > MAX_PORT) {
                    msg = Messages.getString("NetProxyViewItem.ProxyError.0");
                    newState = STATE.ERROR;
                }
            }
        }
        if (newState != this.state) {
            this.setState(newState);
            this.viewItem.setState(this.state, msg);
        }
    }
}

