/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms;

import java.util.ArrayList;
import java.util.List;
import org.tizen.emulator.manager.vms.type.SKIN_SHAPE;

public class SkinShapeList {
    private final List<SKIN_SHAPE> list = new ArrayList<SKIN_SHAPE>();

    private SkinShapeList() {
    }

    public static SkinShapeList create(String shapeProperty) {
        String[] arr;
        SkinShapeList skinShapeList = new SkinShapeList();
        if (shapeProperty == null) {
            shapeProperty = SKIN_SHAPE.SQUARE.name();
        }
        for (String str : arr = shapeProperty.split(",")) {
            skinShapeList.add(SKIN_SHAPE.find(str.trim()));
        }
        if (skinShapeList.list.size() == 0) {
            skinShapeList.add(SKIN_SHAPE.SQUARE);
        }
        return skinShapeList;
    }

    public void add(SKIN_SHAPE shape) {
        if (!this.hasShape(shape)) {
            this.list.add(shape);
        }
    }

    public SKIN_SHAPE get(int index) {
        if (this.list.size() >= index + 1) {
            return this.list.get(index);
        }
        return null;
    }

    public int size() {
        return this.list.size();
    }

    public boolean hasShape(SKIN_SHAPE shape) {
        for (SKIN_SHAPE thisShape : this.list) {
            if (thisShape != shape) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean hasShape(org.tizen.emulator.manager.vms.SKIN_SHAPE shape) {
        for (SKIN_SHAPE thisShape : this.list) {
            if (!thisShape.toString().equals(shape.toString())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String str = "";
        for (SKIN_SHAPE shape : this.list) {
            str = str.isEmpty() ? shape.toString() : str + ", " + shape.toString();
        }
        return str;
    }
}

