/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.item;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.ui.item.ViewItemFactory;
import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.ui.tabview.controller.CameraImageItemController;
import org.tizen.emulator.manager.ui.tabview.controller.CameraTypeItemController;
import org.tizen.emulator.manager.ui.tabview.controller.CheckBoxController;
import org.tizen.emulator.manager.ui.tabview.controller.CheckLabelViewController;
import org.tizen.emulator.manager.ui.tabview.controller.ComboViewController;
import org.tizen.emulator.manager.ui.tabview.controller.DeviceCheckLabelViewController;
import org.tizen.emulator.manager.ui.tabview.controller.DeviceDisplayViewController;
import org.tizen.emulator.manager.ui.tabview.controller.DeviceTemplateComboController;
import org.tizen.emulator.manager.ui.tabview.controller.DeviceTemplateLabelController;
import org.tizen.emulator.manager.ui.tabview.controller.DirSharingItemController;
import org.tizen.emulator.manager.ui.tabview.controller.DisplayViewController;
import org.tizen.emulator.manager.ui.tabview.controller.FileViewController;
import org.tizen.emulator.manager.ui.tabview.controller.GLVersionController;
import org.tizen.emulator.manager.ui.tabview.controller.HWSupportItemController;
import org.tizen.emulator.manager.ui.tabview.controller.LabelViewController;
import org.tizen.emulator.manager.ui.tabview.controller.NetConnectTypeItemController;
import org.tizen.emulator.manager.ui.tabview.controller.NetProxyItemController;
import org.tizen.emulator.manager.ui.tabview.controller.NetProxyLabelController;
import org.tizen.emulator.manager.ui.tabview.controller.NetTCPIPItemController;
import org.tizen.emulator.manager.ui.tabview.controller.NetTCPIPLabelController;
import org.tizen.emulator.manager.ui.tabview.controller.NetTapDeviceItemController;
import org.tizen.emulator.manager.ui.tabview.controller.PlatformLabelViewController;
import org.tizen.emulator.manager.ui.tabview.controller.ProcessorsViewController;
import org.tizen.emulator.manager.ui.tabview.controller.RamSizeViewController;
import org.tizen.emulator.manager.ui.tabview.controller.TextViewController;
import org.tizen.emulator.manager.ui.tabview.controller.ToggleButtonController;
import org.tizen.emulator.manager.ui.tabview.controller.VMNameViewController;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.template.Template;
import org.tizen.emulator.manager.ui.template.item.Group;
import org.tizen.emulator.manager.ui.template.item.Item;

public class CommonViewItemFactoryV3
implements ViewItemFactory {
    static Map<String, Class<? extends ViewItemController>> viewItemMap = new HashMap<String, Class<? extends ViewItemController>>();
    protected MODE mode = MODE.NONE;

    @Override
    public void setMode(MODE mode) {
        this.mode = mode;
    }

    @Override
    public MODE getMode() {
        return this.mode;
    }

    @Override
    public List<Item> getTabList(Template template) {
        Group group = this.getDefaultItemGroup(template);
        if (group == null) {
            return null;
        }
        Item general = null;
        if (this.mode == MODE.DETAIL) {
            general = new Item();
            general.setName("general");
            for (Item item : group.getItems()) {
                if (item.getSupportMode() != MODE.NONE && item.getSupportMode() != this.mode) continue;
                if (item.getName().equals("general")) {
                    for (Item i : item.getSubItems()) {
                        general.addSubItem(i);
                    }
                    continue;
                }
                if (item.getName().equals("device")) {
                    for (Item i : item.getSubItems()) {
                        general.addSubItem(i);
                    }
                    continue;
                }
                general.addSubItem(item);
            }
            ArrayList<Item> list = new ArrayList<Item>();
            list.add(general);
            return list;
        }
        ArrayList<Item> tabList = new ArrayList<Item>();
        for (Item item : group.getItems()) {
            if (item.getSupportMode() != MODE.NONE && item.getSupportMode() != this.mode) continue;
            if (item.getName().equals("general")) {
                general = item;
            }
            if (!item.getType().equals("tab") && !item.getType().equals("label")) {
                if (general == null) continue;
                general.addSubItem(item);
                continue;
            }
            tabList.add(item);
        }
        return tabList;
    }

    private Group getDefaultItemGroup(Template template) {
        for (Group group : template.getGroupItems()) {
            if (!group.getName().equals("default")) continue;
            return group;
        }
        return null;
    }

    @Override
    public List<ViewItemController> getViewItemList(Item tab) {
        return this.getViewItemList(tab, null);
    }

    @Override
    public List<ViewItemController> getViewItemList(Item tab, ViewItemController parent) {
        ArrayList<ViewItemController> itemList = new ArrayList<ViewItemController>();
        for (Item item : tab.getSubItems()) {
            List<ViewItemController> subList;
            ViewItemController viewItem;
            if (item.isExperimental() || !item.isSupportOS() || item.getSupportMode() != MODE.NONE && item.getSupportMode() != this.mode || (viewItem = this.getViewItem(item, parent)) == null) continue;
            if (!item.getSubItems().isEmpty() && (subList = this.getViewItemList(item, viewItem)) != null) {
                viewItem.addSubViewItem(subList);
            }
            if (tab.getType().equals("label")) {
                viewItem.setLabelName(tab.getName());
            }
            viewItem.makeViewItem();
            itemList.add(viewItem);
        }
        return itemList;
    }

    @Override
    public ViewItemController getViewItem(Item item, ViewItemController parentItem) {
        Class<? extends ViewItemController> itemClass = null;
        itemClass = this.mode == MODE.DETAIL ? viewItemMap.get(item.getName() + "Label") : viewItemMap.get(item.getName());
        if (itemClass == null) {
            itemClass = this.mode == MODE.DETAIL ? (item.getType().equals("checkLabel") || item.getType().equals("checkbox") ? viewItemMap.get(item.getType()) : viewItemMap.get("label")) : viewItemMap.get(item.getType());
        }
        if (itemClass == null) {
            return null;
        }
        ViewItemController viewItem = this.makeViewItem(itemClass, item, parentItem);
        return viewItem;
    }

    protected ViewItemController makeViewItem(Class<? extends ViewItemController> itemClass, Item item, ViewItemController parentItem) {
        ViewItemController viewItem = null;
        try {
            if (parentItem == null) {
                Constructor<? extends ViewItemController> cons = itemClass.getConstructor(Item.class);
                try {
                    viewItem = cons.newInstance(item);
                }
                catch (IllegalArgumentException | InvocationTargetException e) {
                    EMLogger.getLogger().warning(e.getMessage());
                }
            } else {
                Constructor<? extends ViewItemController> cons = itemClass.getConstructor(Item.class, ViewItemController.class);
                try {
                    viewItem = cons.newInstance(item, parentItem);
                }
                catch (IllegalArgumentException | InvocationTargetException e) {
                    EMLogger.getLogger().warning(e.getMessage());
                }
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException e) {
            EMLogger.getLogger().warning(e.getMessage());
        }
        return viewItem;
    }

    static {
        viewItemMap.put("name", VMNameViewController.class);
        viewItemMap.put("profile", LabelViewController.class);
        viewItemMap.put("baseImage", LabelViewController.class);
        viewItemMap.put("platform", LabelViewController.class);
        viewItemMap.put("fileShare", DirSharingItemController.class);
        viewItemMap.put("rearImage", CameraImageItemController.class);
        viewItemMap.put("rearType", CameraTypeItemController.class);
        viewItemMap.put("proxy", NetProxyItemController.class);
        viewItemMap.put("netConnectType", NetConnectTypeItemController.class);
        viewItemMap.put("netTapDevice", NetTapDeviceItemController.class);
        viewItemMap.put("netIpInfo", NetTCPIPItemController.class);
        viewItemMap.put("display", DisplayViewController.class);
        viewItemMap.put("deviceTemplate", DeviceTemplateComboController.class);
        viewItemMap.put("template-name", DeviceTemplateLabelController.class);
        viewItemMap.put("template-display", DeviceDisplayViewController.class);
        viewItemMap.put("glVersion", GLVersionController.class);
        viewItemMap.put("processors", ProcessorsViewController.class);
        viewItemMap.put("ramSize", RamSizeViewController.class);
        viewItemMap.put("sensor", DeviceCheckLabelViewController.class);
        viewItemMap.put("connectivity", DeviceCheckLabelViewController.class);
        viewItemMap.put("cpu", HWSupportItemController.class);
        viewItemMap.put("gpu", HWSupportItemController.class);
        viewItemMap.put("baseImageLabel", PlatformLabelViewController.class);
        viewItemMap.put("proxyLabel", NetProxyLabelController.class);
        viewItemMap.put("netIpInfoLabel", NetTCPIPLabelController.class);
        viewItemMap.put("textInput", TextViewController.class);
        viewItemMap.put("text", TextViewController.class);
        viewItemMap.put("combo", ComboViewController.class);
        viewItemMap.put("toggle", ToggleButtonController.class);
        viewItemMap.put("label", LabelViewController.class);
        viewItemMap.put("checkLabel", CheckLabelViewController.class);
        viewItemMap.put("checkbox", CheckBoxController.class);
        viewItemMap.put("file", FileViewController.class);
    }
}

