/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.console.util;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.ByteArrayOutputStream;
import java.io.Console;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.tizen.emulator.manager.console.Option;
import org.tizen.emulator.manager.tool.RemoteManager;

public class RemoteManagerCLI {
    private static String sshUserPasswd = "";

    public void storeRemoteInfo(ArrayList<Option> commandList) {
        for (Option c : commandList) {
            switch (c.getShortName().charAt(0)) {
                case 'e': {
                    RemoteManager.setRemoteIp(c.getCurrentValue());
                    break;
                }
                case 'u': {
                    RemoteManager.setRemoteUserAccount(c.getCurrentValue());
                    break;
                }
                case 'l': {
                    RemoteManager.setSDK_pathNum(c.getCurrentValue());
                }
            }
        }
        RemoteManager.setSpiceMode(true);
    }

    public void sshCmd(List<String> cmd) {
        Console cons = System.console();
        char[] passwd = cons.readPassword(RemoteManager.getRemoteUserAccount() + "@" + RemoteManager.getRemoteIp() + "'s " + "password:", new Object[0]);
        if (passwd != null) {
            sshUserPasswd = new String(passwd);
        }
        cmd.add("java -jar");
        cmd.add("managerPath");
    }

    public String getRemoteOutput(ChannelExec channel) {
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            InputStream in = channel.getInputStream();
            while (true) {
                int cnt;
                if (in.available() > 0 && (cnt = in.read(buffer, 0, 1024)) >= 0) {
                    bos.write(buffer, 0, cnt);
                    continue;
                }
                if (channel.isClosed()) break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bos.toString();
    }

    public boolean runRemoteCmd(List<String> cmd) {
        JSch jsch = new JSch();
        try {
            Session session = jsch.getSession(RemoteManager.getRemoteUserAccount(), RemoteManager.getRemoteIp(), 22);
            session.setPassword(sshUserPasswd);
            session.setConfig("StrictHostKeyChecking", "no");
            session.connect();
            ChannelExec channel = (ChannelExec)session.openChannel("exec");
            String getSDK_pathCmd = "sed -n '" + RemoteManager.getSDK_pathNum() + "p' ~/.installmanager/multisdkpath";
            channel.setCommand(getSDK_pathCmd);
            channel.connect();
            String remote_sdkPath = this.getRemoteOutput(channel);
            channel.disconnect();
            String remote_managerPath = remote_sdkPath.substring(0, remote_sdkPath.length() - 1) + "/tools/emulator/bin/emulator-manager.jar";
            String excuteCmd = "";
            for (int i = 0; i < cmd.size(); ++i) {
                excuteCmd = cmd.get(i).equals("managerPath") ? excuteCmd + remote_managerPath : excuteCmd + cmd.get(i);
                excuteCmd = excuteCmd + " ";
            }
            channel = (ChannelExec)session.openChannel("exec");
            channel.setCommand(excuteCmd);
            channel.connect();
            String theOutput = this.getRemoteOutput(channel);
            channel.disconnect();
            session.disconnect();
            System.out.println("\n" + RemoteManager.getRemoteIp() + "'s result:");
            System.out.println(theOutput);
        }
        catch (JSchException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean launchRemoteEmulator(String name, String path, boolean isTest) {
        ArrayList<String> cmd = new ArrayList<String>();
        this.sshCmd(cmd);
        cmd.add("launch");
        if (name != null) {
            cmd.add("-n " + name);
        }
        if (path != null) {
            cmd.add("-p " + path);
        }
        if (RemoteManager.getSpiceMode()) {
            cmd.add("-s");
        }
        this.runRemoteCmd(cmd);
        return true;
    }
}

