/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.console;

import org.tizen.emulator.manager.console.Command;
import org.tizen.emulator.manager.console.Option;
import org.tizen.emulator.manager.console.processor.ConsoleProcessor;
import org.tizen.emulator.manager.console.resources.Messages;
import org.tizen.emulator.manager.console.resources.StringResources;
import org.tizen.emulator.manager.console.util.OutputUtil;
import org.tizen.emulator.manager.platform.Profile;
import org.tizen.emulator.manager.platform.ProfileList;

class ListDevice
extends Command {
    public ListDevice() {
        this.command = "list-template";
        this.shortDescription = Messages.getString("ListDevice.ShortDescription");
        this.description = Messages.getString("ListDevice.Description");
        this.usage = Messages.getString("ListDevice.Usage.1") + StringResources.NEW_LINE + Messages.getString("ListDevice.Usage.2") + StringResources.NEW_LINE + Messages.getString("ListDevice.Usage.3") + StringResources.NEW_LINE + Messages.getString("ListDevice.Usage.4");
        this.optionList.add(new Option("P", "profile", StringResources.DESC_LIST_DEVICE_PROFILE, "", false, true, "PROFILE"));
        this.optionList.add(new Option("d", "detail", StringResources.DESC_LIST_DEVICE_DETAIL, "", false, false));
    }

    @Override
    public boolean process() {
        Profile profile = null;
        boolean isDetail = false;
        for (Option c : this.optionList) {
            if (!c.isInCommandLine()) continue;
            switch (c.getShortName().charAt(0)) {
                case 'd': {
                    isDetail = true;
                    break;
                }
                case 'P': {
                    String name = c.getCurrentValue();
                    profile = ProfileList.get(name);
                    if (profile != null) break;
                    OutputUtil.printError(name + " " + Messages.getString("List.Error.Profile"));
                    return false;
                }
            }
        }
        ConsoleProcessor processor = new ConsoleProcessor();
        int count = processor.printDeviceList(profile, isDetail);
        if (count == 0) {
            OutputUtil.print(Messages.getString("ListDevice.EmptyList"));
        }
        return true;
    }
}

