/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.controller;

import org.tizen.emulator.manager.devices.DeviceTemplate;
import org.tizen.emulator.manager.devices.DeviceTemplateList;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.controller.ComboViewController;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.template.item.Item;

public class DeviceTemplateComboController
extends ComboViewController {
    private String template = "";

    public DeviceTemplateComboController(Item item) {
        super(item);
    }

    @Override
    protected void onChangedValue(Event event) {
        ItemEvent iEvent = new ItemEvent("deviceTemplate", this);
        iEvent.oldValue = this.template;
        iEvent.newValue = event.text;
        iEvent.data = event.data;
        iEvent.oldState = this.state;
        iEvent.newState = this.state;
        ViewItemController.sendChangeEvent(iEvent);
        this.template = event.text;
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        Platform platform = (Platform)value.getObjectValue("baseImage");
        if (platform == null) {
            this.comboView.setEnable(false);
            return;
        }
        for (DeviceTemplate template : DeviceTemplateList.getDeviceTemplateListByPlatform(platform)) {
            this.comboView.addItem(template.getValue().getName(), template);
        }
        this.template = value.getStringValue("deviceTemplate");
        this.comboView.selectItem(this.template);
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        value.setObjectValue("deviceTemplate", this.comboView.getSelectedData());
    }
}

