/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.dialog;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import org.tizen.emulator.manager.tool.OSUtil;

public class ButtonBar {
    public static final String BUTTON_DATA_PROPERTY = "org.tizen.em.ui.dialog.ButtonBar.ButtonData";
    public static final String BUTTON_ORDER_WINDOWS = "L_E+BX_YNOMFCAH_R";
    public static final String BUTTON_ORDER_MAC_OS = "L_HE+BX_NCYOMFA_R";
    public static final String BUTTON_ORDER_LINUX = "L_HE+NYACBXOMF_R";
    private final ObservableList<Node> buttons = FXCollections.observableArrayList();
    private final StringProperty buttonOrderProperty = new SimpleStringProperty((Object)this, "buttonOrder");
    private final DoubleProperty buttonMinWidthProperty = new SimpleDoubleProperty((Object)this, "buttonMinWidthProperty");
    private final DoubleProperty buttonPrefHeightProperty = new SimpleDoubleProperty((Object)this, "buttonPrefHeightProperty");
    private final HBox buttonPanel;

    public static void setButtonData(Node button, ButtonData buttonData) {
        ObservableMap properties = button.getProperties();
        ObjectProperty property = (ObjectProperty)properties.get(BUTTON_DATA_PROPERTY);
        if (property == null) {
            property = new SimpleObjectProperty((Object)button, "buttonData", (Object)buttonData);
        }
        property.set((Object)buttonData);
        properties.put(BUTTON_DATA_PROPERTY, property);
    }

    public static ButtonData getButtonData(Node button) {
        ObservableMap properties = button.getProperties();
        if (properties.containsKey(BUTTON_DATA_PROPERTY)) {
            ObjectProperty property = (ObjectProperty)properties.get(BUTTON_DATA_PROPERTY);
            return property == null ? null : (ButtonData)((Object)property.get());
        }
        return null;
    }

    public ButtonBar(HBox box, int buttonBarPrefHeight) {
        this.buttonPanel = box;
        this.buttonPanel.setPrefHeight((double)buttonBarPrefHeight);
        this.setButtonMinWidth(86.0);
        if (OSUtil.isMac()) {
            this.setButtonOrder(BUTTON_ORDER_MAC_OS);
        } else if (OSUtil.isLinux()) {
            this.setButtonOrder(BUTTON_ORDER_LINUX);
        } else {
            this.setButtonOrder(BUTTON_ORDER_WINDOWS);
        }
    }

    public final ObservableList<Node> getButtons() {
        return this.buttons;
    }

    public final void setButtonOrder(String buttonOrder) {
        this.buttonOrderProperty.set((Object)buttonOrder);
    }

    public final void setButtonMinWidth(double value) {
        this.buttonMinWidthProperty.set(value);
    }

    public final void setButtonPrefHeight(double value) {
        this.buttonPrefHeightProperty.set(value);
    }

    public final double getButtonMinWidth() {
        return this.buttonMinWidthProperty.get();
    }

    public HBox getButtonPanel() {
        return this.buttonPanel;
    }

    public void layoutButtons() {
        int i;
        this.buttonPanel.getChildren().clear();
        char[] buttonOrderArr = ((String)this.buttonOrderProperty.get()).toCharArray();
        Spacer spacer = Spacer.NONE;
        block0: for (i = 0; i < buttonOrderArr.length; ++i) {
            char type = buttonOrderArr[i];
            if (type == '+') {
                spacer = spacer.replace(Spacer.DYNAMIC);
                continue;
            }
            if (type == '_') {
                spacer = spacer.replace(Spacer.FIXED);
                continue;
            }
            for (Node button : this.buttons) {
                if (button == null || ButtonBar.getButtonData(button).typeCode.indexOf(type) != 0) continue;
                spacer.add((Pane)this.buttonPanel, true);
                this.sizeButton(button);
                this.buttonPanel.getChildren().add((Object)button);
                HBox.setMargin((Node)button, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
                HBox.setHgrow((Node)button, (Priority)Priority.NEVER);
                spacer = spacer.replace(Spacer.NONE);
                continue block0;
            }
        }
        for (i = 0; i < this.buttons.size(); ++i) {
            Node btn = (Node)this.buttons.get(i);
            ButtonData btnData = ButtonBar.getButtonData(btn);
            if (btnData == null || !btnData.isDefaultButton()) continue;
            btn.requestFocus();
            break;
        }
    }

    private void sizeButton(Node btn) {
        if (btn instanceof Button) {
            Button regionBtn = (Button)btn;
            regionBtn.setPrefWidth(this.buttonMinWidthProperty.get());
            regionBtn.setPrefHeight(this.buttonPrefHeightProperty.get());
        }
    }

    private static enum Spacer {
        FIXED{

            @Override
            protected Node create(boolean edgeCase) {
                if (edgeCase) {
                    return null;
                }
                Region spacer = new Region();
                ButtonBar.setButtonData((Node)spacer, ButtonData.SMALL_GAP);
                spacer.setMinWidth(10.0);
                HBox.setHgrow((Node)spacer, (Priority)Priority.NEVER);
                return spacer;
            }
        }
        ,
        DYNAMIC{

            @Override
            protected Node create(boolean edgeCase) {
                Region spacer = new Region();
                ButtonBar.setButtonData((Node)spacer, ButtonData.BIG_GAP);
                spacer.setMinWidth(edgeCase ? 0.0 : 10.0);
                HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
                return spacer;
            }

            @Override
            public Spacer replace(Spacer spacer) {
                return FIXED == spacer ? this : spacer;
            }
        }
        ,
        NONE;


        protected Node create(boolean edgeCase) {
            return null;
        }

        public Spacer replace(Spacer spacer) {
            return spacer;
        }

        public void add(Pane pane, boolean edgeCase) {
            Node spacer = this.create(edgeCase);
            if (spacer != null) {
                pane.getChildren().add((Object)spacer);
            }
        }
    }

    public static enum ButtonData {
        LEFT("L", false, false),
        RIGHT("R", false, false),
        HELP("H", false, false),
        HELP_2("E", false, false),
        YES("Y", false, true),
        NO("N", true, false),
        APPLY("A", false, false),
        CANCEL_CLOSE("C", true, false),
        OK_DONE("O", false, true),
        CONFIRM("M", false, true),
        NEXT_FORWARD("X", false, true),
        BACK_PREVIOUS("B", false, false),
        BIG_GAP("+", false, false),
        SMALL_GAP("_", false, false),
        FINISH("F", false, true);

        private final String typeCode;
        private final boolean cancelButton;
        private final boolean defaultButton;

        private ButtonData(String type, boolean cancelButton, boolean defaultButton) {
            this.typeCode = type;
            this.cancelButton = cancelButton;
            this.defaultButton = defaultButton;
        }

        public String getTypeCode() {
            return this.typeCode;
        }

        public final boolean isCancelButton() {
            return this.cancelButton;
        }

        public final boolean isDefaultButton() {
            return this.defaultButton;
        }
    }
}

