/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.create;

import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;
import org.tizen.emulator.manager.ui.controller.create.DeviceTemplateData;
import org.tizen.emulator.manager.ui.controller.vms.ROW_STATE;
import org.tizen.emulator.manager.ui.resources.Images;

public class DeviceTemplateListCell
extends ListCell<DeviceTemplateData> {
    static final Color TEXT_FILL_CUSTOM = Color.web((String)"#00b3ba");
    static final Color TEXT_FILL_SELECT = Color.web((String)"#008aee");
    static final Color TEXT_FILL_NORMAL = Color.web((String)"#585858");
    Label iconLabel;
    Label versionLabel;
    Label nameLabel;
    Label resolutionTitle = new Label("Resolution");
    Label skinTitle = new Label("Skin");
    Label resolutionValue;
    Label skinValue;
    private DeviceTemplateData data;
    private SimpleObjectProperty<ROW_STATE> state;
    private HBox hBox;
    private final EventHandler<MouseEvent> mouseHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent arg0) {
            if (arg0.getEventType() == MouseEvent.MOUSE_ENTERED) {
                if (DeviceTemplateListCell.this.state.get() == ROW_STATE.SELECTED) {
                    return;
                }
                DeviceTemplateListCell.this.state.set((Object)ROW_STATE.OVER);
            } else if (arg0.getEventType() == MouseEvent.MOUSE_EXITED) {
                if (DeviceTemplateListCell.this.state.get() == ROW_STATE.SELECTED) {
                    return;
                }
                DeviceTemplateListCell.this.state.set((Object)ROW_STATE.NORMAL);
            }
        }
    };
    private final ChangeListener<ROW_STATE> rowStateListener = new ChangeListener<ROW_STATE>(){

        public void changed(ObservableValue<? extends ROW_STATE> arg, ROW_STATE oldValue, ROW_STATE newValue) {
            DeviceTemplateListCell.this.drawBox(newValue);
        }
    };

    protected void updateItem(DeviceTemplateData data, boolean isblank) {
        super.updateItem((Object)data, isblank);
        this.setGraphic(null);
        if (this.state != null) {
            this.state.removeListener(this.rowStateListener);
            this.state = null;
        }
        if (this.hBox != null) {
            this.hBox.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseHandler);
            this.hBox.removeEventHandler(MouseEvent.MOUSE_EXITED, this.mouseHandler);
            this.hBox = null;
        }
        if (isblank) {
            return;
        }
        this.data = data;
        this.hBox = new HBox();
        this.hBox.setSpacing(38.0);
        this.hBox.setPadding(new Insets(12.0, 0.0, 12.0, 32.0));
        VBox vBox = new VBox();
        vBox.setAlignment(Pos.CENTER);
        vBox.setSpacing(8.0);
        GridPane textPane = new GridPane();
        textPane.setPadding(new Insets(3.0, 0.0, 0.0, 0.0));
        textPane.setVgap(6.0);
        textPane.setHgap(20.0);
        this.hBox.getChildren().addAll((Object[])new Node[]{vBox, textPane});
        this.iconLabel = new Label();
        this.versionLabel = new Label("ver. " + data.getVersion());
        this.nameLabel = new Label(data.getName());
        this.resolutionValue = new Label(data.getResolution());
        this.skinValue = new Label(data.getSkinName());
        this.nameLabel.getStyleClass().add((Object)"template-name-label");
        this.state = data.getState();
        this.drawBox((ROW_STATE)((Object)this.state.get()));
        this.state.removeListener(this.rowStateListener);
        this.state.addListener(this.rowStateListener);
        vBox.getChildren().addAll((Object[])new Node[]{this.iconLabel, this.versionLabel});
        textPane.add((Node)this.nameLabel, 0, 0, 2, 1);
        textPane.add((Node)this.resolutionTitle, 0, 2);
        textPane.add((Node)this.resolutionValue, 1, 2);
        textPane.add((Node)this.skinTitle, 0, 3);
        textPane.add((Node)this.skinValue, 1, 3);
        this.setGraphic((Node)this.hBox);
        this.hBox.addEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseHandler);
        this.hBox.addEventHandler(MouseEvent.MOUSE_EXITED, this.mouseHandler);
    }

    private void drawBox(ROW_STATE state) {
        switch (state) {
            case NORMAL: {
                this.iconLabel.setGraphic((Node)new ImageView(Images.get(this.data.getIcon())));
                this.versionLabel.setTextFill((Paint)TEXT_FILL_NORMAL);
                this.versionLabel.setStyle("-fx-font-weight:normal");
                break;
            }
            case OVER: {
                this.iconLabel.setGraphic((Node)new ImageView(Images.get(this.data.getOverIcon())));
                break;
            }
            case SELECTED: {
                this.iconLabel.setGraphic((Node)new ImageView(Images.get(this.data.getSelectedIcon())));
                this.versionLabel.setTextFill((Paint)TEXT_FILL_SELECT);
                this.versionLabel.setStyle("-fx-font-weight:bold");
                this.setTextColor();
                break;
            }
        }
    }

    private void setTextColor() {
        this.nameLabel.setTextFill((Paint)TEXT_FILL_NORMAL);
        this.resolutionValue.setTextFill((Paint)TEXT_FILL_NORMAL);
        this.skinValue.setTextFill((Paint)TEXT_FILL_NORMAL);
        this.resolutionTitle.setTextFill((Paint)TEXT_FILL_NORMAL);
        this.skinTitle.setTextFill((Paint)TEXT_FILL_NORMAL);
    }

    static Callback<ListView<DeviceTemplateData>, ListCell<DeviceTemplateData>> extractor() {
        return new Callback<ListView<DeviceTemplateData>, ListCell<DeviceTemplateData>>(){

            public ListCell<DeviceTemplateData> call(ListView<DeviceTemplateData> arg0) {
                return new DeviceTemplateListCell();
            }
        };
    }
}

