/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.vms;

import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import org.tizen.emulator.manager.ui.control.TizenCheckBox;
import org.tizen.emulator.manager.ui.controller.vms.VMCheckSelectEvent;

public class CheckBoxTableColumn<S, T>
extends TableColumn<S, T> {
    private static SimpleIntegerProperty checkCountProperty;
    private final TizenCheckBox checkBox;
    private final StackPane containerPane;
    private final EventHandler<MouseEvent> handler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent e) {
            if (e.getEventType() == MouseEvent.MOUSE_PRESSED) {
                CheckBoxTableColumn.this.checkBox.setSelected(!CheckBoxTableColumn.this.checkBox.isSelected());
                VMCheckSelectEvent event = new VMCheckSelectEvent(CheckBoxTableColumn.this.checkBox.isSelected());
                Event.fireEvent((EventTarget)CheckBoxTableColumn.this.getTableView(), (Event)event);
                e.consume();
            } else if (e.getEventType() == MouseEvent.MOUSE_RELEASED) {
                e.consume();
            }
        }
    };

    public CheckBoxTableColumn() {
        super("");
        this.checkBox = new TizenCheckBox();
        this.checkBox.setSpacing(0.0);
        this.containerPane = new StackPane();
        this.containerPane.getChildren().add((Object)this.checkBox.getPane());
        this.setGraphic((Node)this.containerPane);
        this.containerPane.addEventFilter(MouseEvent.MOUSE_PRESSED, this.handler);
        this.containerPane.addEventFilter(MouseEvent.MOUSE_RELEASED, this.handler);
        checkCountProperty = new SimpleIntegerProperty(0);
        checkCountProperty.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> arg0, Number arg1, Number arg2) {
                int itemSize = CheckBoxTableColumn.this.getTableView().getItems().size();
                if (itemSize == 0 || itemSize != checkCountProperty.get()) {
                    CheckBoxTableColumn.this.checkBox.setSelected(false);
                } else {
                    CheckBoxTableColumn.this.checkBox.setSelected(true);
                }
            }
        });
    }

    public static SimpleIntegerProperty checkCountProperty() {
        return checkCountProperty;
    }
}

