/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.vms;

import javafx.scene.Node;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.util.Callback;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.ui.Messages;
import org.tizen.emulator.manager.ui.item.VMItem;
import org.tizen.emulator.manager.ui.resources.ImageKind;
import org.tizen.emulator.manager.ui.resources.Images;
import org.tizen.emulator.manager.vms.VMProperty;

class VMStatusCell
extends TableCell<VMItem, String> {
    private static Double MIN_SIZE = new Double(10.0);
    private static Double PREF_SIZE = new Double(15.0);
    private final ProgressIndicator exportStatus = new ProgressIndicator();

    VMStatusCell() {
        this.exportStatus.setVisible(false);
        this.exportStatus.setMinSize(MIN_SIZE.doubleValue(), MIN_SIZE.doubleValue());
        this.exportStatus.setPrefSize(PREF_SIZE.doubleValue(), PREF_SIZE.doubleValue());
        this.exportStatus.setMaxSize(PREF_SIZE.doubleValue(), PREF_SIZE.doubleValue());
    }

    protected void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (this.isEmpty()) {
            this.setGraphic(null);
            return;
        }
        VMItem vmItem = (VMItem)this.getTableRow().getItem();
        if (item == null || vmItem == null) {
            return;
        }
        EMLogger.getLogger().fine("Update status of item: " + vmItem.getName() + " - " + item);
        ImageView imageview = new ImageView();
        VMProperty.State state = vmItem.getState();
        VMProperty.Health health = vmItem.getHealth();
        if (state == VMProperty.State.RUNNING || state == VMProperty.State.LAUNCHING) {
            imageview.setImage(Images.get(ImageKind.ICON_STATE_RUNNING));
            this.setGraphic((Node)imageview);
        } else if (state == VMProperty.State.BUSY) {
            this.exportStatus.setVisible(true);
            this.setGraphic((Node)this.exportStatus);
        } else if (health == VMProperty.Health.PLATFORM_IMAGE_NOT_ACCESSIBLE) {
            imageview.setImage(Images.get(ImageKind.ICON_STATE_ERROR));
            this.setGraphic((Node)imageview);
            this.setTooltip(new Tooltip(Messages.getString("VMStatus.tooltip.0")));
        } else if (health == VMProperty.Health.PLATFORM_IS_NOT_AVAILABLE) {
            imageview.setImage(Images.get(ImageKind.ICON_STATE_ERROR));
            this.setGraphic((Node)imageview);
            this.setTooltip(new Tooltip(Messages.getString("VMStatus.tooltip.1")));
        } else {
            this.exportStatus.setVisible(false);
            imageview.setImage(null);
            this.setGraphic((Node)imageview);
        }
        this.setText("");
    }

    static Callback<TableColumn<VMItem, String>, TableCell<VMItem, String>> extractor() {
        return new Callback<TableColumn<VMItem, String>, TableCell<VMItem, String>>(){

            public TableCell<VMItem, String> call(TableColumn<VMItem, String> param) {
                VMStatusCell cell = new VMStatusCell();
                return cell;
            }
        };
    }
}

