/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tizen.emulator.manager.devices.DeviceTemplateList;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.platform.PlatformList;
import org.tizen.emulator.manager.platform.PlatformStringResources;
import org.tizen.emulator.manager.platform.StandardPlatform;
import org.tizen.emulator.manager.platform.custom.CustomPlatformImageValue;
import org.tizen.emulator.manager.vms.DiskImageFormat;
import org.tizen.emulator.manager.vms.DiskImageType;
import org.tizen.emulator.manager.vms.OCIList;
import org.tizen.emulator.manager.vms.VMOption;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.VMPropertyValue;
import org.tizen.emulator.manager.vms.type.RESOLUTION;
import org.tizen.emulator.manager.vms.xml.DiskImageFileType;
import org.tizen.emulator.manager.vms.xml.EmulatorConfiguration;
import org.tizen.emulator.manager.vms.xml.OptionType;
import org.tizen.emulator.manager.vms.xml.SubOptionType;

public class VMPropertyValueCreator {
    private final EmulatorConfiguration configuration;

    public static VMPropertyValue create(VMProperty property, EmulatorConfiguration configuration) {
        VMPropertyValueCreator creator = new VMPropertyValueCreator(configuration);
        VMPropertyValue value = new VMPropertyValue(property);
        creator.settingConfigure(value);
        creator.settingPlatform(value);
        return value;
    }

    private VMPropertyValueCreator(EmulatorConfiguration configuration) {
        this.configuration = configuration;
    }

    private void settingConfigure(VMPropertyValue value) {
        if (value == null || this.configuration == null) {
            return;
        }
        value.vmName = this.getName();
        value.childImagePath = this.getChildImagePath();
        value.swapImagePath = this.getSwapImagePath();
        value.deviceName = this.getDeviceTemplateName();
        value.devicePath = this.getDeviceTemplatePath();
        value.deivceVersion = this.getDeviceTemplateVersion();
        if (!value.devicePath.isEmpty()) {
            value.setDeviceTemplate(DeviceTemplateList.findDeviceTemplate(value.devicePath));
        }
        int width = this.getDisplayWidth();
        int height = this.getDisplayHeight();
        value.resolution = RESOLUTION.findAndCreateResolution(width, height);
        value.dpi = this.getDisplayDPI();
        value.screenSize = this.getDisplaySize();
        value.skinPath = this.getSkinPath();
        value.fileSharePath = this.getFileSharingPath();
        if (value.fileSharePath != null) {
            value.isFileShareSupport = true;
        } else {
            value.fileSharePath = "";
        }
        value.ramSize = this.getRamSize();
        value.cpu = this.getCPUCount();
        value.isHWVirtualization = this.supportHWVirtualization();
        value.isGLAcceleration = this.supporGLAcceleration();
        value.isSupportSuspend = this.supportSuspend();
        value.maxTouchCount = this.getMaxTouchPoint();
        if (value.ociDevice == null) {
            OCIList.getInstance();
        }
        value.ociOptions = this.getOciOptions();
        value.advancedVMOptionList = this.getAdvancedOptionList();
    }

    private void settingPlatform(VMPropertyValue value) {
        if (this.configuration == null) {
            return;
        }
        if (value.vmName == null) {
            return;
        }
        Platform platform = PlatformList.get(this.getPlatformName());
        String baseImagePath = this.getBaseImagePath();
        if (platform == null) {
            platform = Platform.createDummyPlatform(this.getProfile(), this.getPlatformName(), this.getDiskImageType(), this.getDiskImageArch());
        } else if (baseImagePath.isEmpty()) {
            platform = Platform.createCustomInstance(new CustomPlatformImageValue(this.getRawImagePathList(), platform));
        } else if (this.getBaseImageBinaryVersion().equals(PlatformStringResources.CUSTOM_IMAGE_VERSION)) {
            if (!platform.getImageBinaryVersion().equals(PlatformStringResources.CUSTOM_IMAGE_VERSION)) {
                platform = this.createCustomPlatform(platform);
            }
        } else if (platform.getImagePathList().contains(this.getBaseImagePath()) && !this.getBaseImageBinaryVersion().isEmpty() && !this.getBaseImageBinaryVersion().equals(platform.getImageBinaryVersion())) {
            value.isBinaryVersionMatched = false;
        }
        value.setPlatform(platform);
    }

    private List<String> getRawImagePathList() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.isDiskImageNone() || this.configuration.getBaseInformation().getDiskImage().getDiskImageFile().isEmpty()) {
            return list;
        }
        for (DiskImageFileType diskImageFileType : this.configuration.getBaseInformation().getDiskImage().getDiskImageFile()) {
            if (!diskImageFileType.getFormat().equals(DiskImageFormat.RAW.getName())) continue;
            list.add(diskImageFileType.getValue());
        }
        return list;
    }

    private Platform createCustomPlatform(Platform basePlatform) {
        Platform newPlatform = null;
        if (basePlatform instanceof StandardPlatform) {
            CustomPlatformImageValue value = new CustomPlatformImageValue(this.getBaseImagePath(), basePlatform);
            newPlatform = Platform.createTemporaryCustomInstance(value);
        }
        return newPlatform;
    }

    private String getName() {
        if (this.configuration == null || this.configuration.getBaseInformation() == null) {
            return null;
        }
        return this.configuration.getBaseInformation().getName();
    }

    private String getPlatformName() {
        if (this.configuration == null || this.configuration.getBaseInformation() == null) {
            return "";
        }
        return this.configuration.getBaseInformation().getPlatform();
    }

    private String getProfile() {
        if (this.isDiskImageNone()) {
            return "";
        }
        return this.configuration.getBaseInformation().getDiskImage().getProfile();
    }

    private String getDeviceTemplatePath() {
        if (this.configuration == null || this.configuration.getBaseInformation() == null || this.configuration.getBaseInformation().getDeviceTemplate() == null) {
            return "";
        }
        return this.configuration.getBaseInformation().getDeviceTemplate().getPath();
    }

    private String getDeviceTemplateName() {
        if (this.isDeviceTemplateNone()) {
            return "";
        }
        return this.configuration.getBaseInformation().getDeviceTemplate().getName();
    }

    private double getDeviceTemplateVersion() {
        if (this.isDeviceTemplateNone()) {
            return 1.0;
        }
        return this.configuration.getBaseInformation().getDeviceTemplate().getVersion();
    }

    private String getBaseImagePath() {
        String baseImagePath = "";
        if (!this.isDiskImageNone() && !this.configuration.getBaseInformation().getDiskImage().getDiskImageFile().isEmpty()) {
            for (DiskImageFileType diskImageFileType : this.configuration.getBaseInformation().getDiskImage().getDiskImageFile()) {
                String type = diskImageFileType.getType();
                if (type == null || !type.equals(DiskImageType.BASE.getName())) continue;
                baseImagePath = diskImageFileType.getValue();
                break;
            }
        }
        if (!baseImagePath.isEmpty()) {
            return baseImagePath;
        }
        if (!this.isBaseDiskImageNone()) {
            baseImagePath = this.configuration.getBaseInformation().getDiskImage().getBaseDiskImage().getValue();
        }
        return baseImagePath;
    }

    private String getBaseImageBinaryVersion() {
        String binaryVersion = "";
        if (!this.isDiskImageNone() && !this.configuration.getBaseInformation().getDiskImage().getDiskImageFile().isEmpty()) {
            for (DiskImageFileType diskImageFileType : this.configuration.getBaseInformation().getDiskImage().getDiskImageFile()) {
                String type = diskImageFileType.getType();
                if (type == null || !type.equals(DiskImageType.BASE.getName())) continue;
                binaryVersion = diskImageFileType.getVersion();
                break;
            }
        }
        if (!binaryVersion.isEmpty()) {
            return binaryVersion;
        }
        if (!this.isBaseDiskImageNone()) {
            binaryVersion = this.configuration.getBaseInformation().getDiskImage().getBaseDiskImage().getVersion();
        }
        return binaryVersion;
    }

    private String getDiskImageType() {
        if (this.isDiskImageNone()) {
            return "custom";
        }
        return this.configuration.getBaseInformation().getDiskImage().getType();
    }

    private String getDiskImageArch() {
        if (this.configuration.getBaseInformation() == null) {
            return "i386";
        }
        return this.configuration.getBaseInformation().getArchitecture();
    }

    private String getChildImagePath() {
        String childImagePath = "";
        if (!this.isDiskImageNone() && !this.configuration.getBaseInformation().getDiskImage().getDiskImageFile().isEmpty()) {
            for (DiskImageFileType diskImageFileType : this.configuration.getBaseInformation().getDiskImage().getDiskImageFile()) {
                String type = diskImageFileType.getType();
                if (type == null || !type.equals(DiskImageType.CHILD.getName())) continue;
                childImagePath = diskImageFileType.getValue();
                break;
            }
        }
        if (!childImagePath.isEmpty()) {
            return childImagePath;
        }
        if (!this.isDiskImageNone() && this.configuration.getBaseInformation().getDiskImage().getCurrentDiskImage() != null) {
            childImagePath = this.configuration.getBaseInformation().getDiskImage().getCurrentDiskImage().getValue();
        }
        return childImagePath;
    }

    private String getSwapImagePath() {
        if (this.isDiskImageNone() || this.configuration.getBaseInformation().getDiskImage().getSwapDiskImage() == null && this.configuration.getBaseInformation().getDiskImage().getDiskImageFile().isEmpty()) {
            return "";
        }
        String swapImagePath = "";
        if (!this.configuration.getBaseInformation().getDiskImage().getDiskImageFile().isEmpty()) {
            for (DiskImageFileType diskImageFileType : this.configuration.getBaseInformation().getDiskImage().getDiskImageFile()) {
                String type = diskImageFileType.getType();
                if (type == null || !type.equals(DiskImageType.SWAP.getName())) continue;
                swapImagePath = diskImageFileType.getValue();
                break;
            }
        } else {
            swapImagePath = this.configuration.getBaseInformation().getDiskImage().getSwapDiskImage().getValue();
        }
        return swapImagePath;
    }

    private String getFileSharingPath() {
        if (this.configuration == null || this.configuration.getUsability() == null || this.configuration.getUsability().getFileSharing() == null) {
            return null;
        }
        return this.configuration.getUsability().getFileSharing().getPath();
    }

    private boolean supportHWVirtualization() {
        if (this.configuration == null || this.configuration.getUsability() == null) {
            return false;
        }
        return this.configuration.getUsability().isHwVirtualization();
    }

    private boolean supporGLAcceleration() {
        if (this.configuration == null || this.configuration.getUsability() == null) {
            return false;
        }
        return this.configuration.getUsability().isHwGLAcceleration();
    }

    private boolean supportSuspend() {
        if (this.configuration == null || this.configuration.getUsability() == null) {
            return false;
        }
        return this.configuration.getUsability().isSupportSuspend();
    }

    private int getDisplayWidth() {
        if (this.configuration == null || this.configuration.getDevice() == null || this.configuration.getDevice().getDisplay() == null || this.configuration.getDevice().getDisplay().getResolution() == null) {
            return 0;
        }
        return this.configuration.getDevice().getDisplay().getResolution().getWidth();
    }

    private int getDisplayHeight() {
        if (this.configuration == null || this.configuration.getDevice() == null || this.configuration.getDevice().getDisplay() == null || this.configuration.getDevice().getDisplay().getResolution() == null) {
            return 0;
        }
        return this.configuration.getDevice().getDisplay().getResolution().getHeight();
    }

    private int getDisplayDPI() {
        if (this.configuration == null || this.configuration.getDevice() == null || this.configuration.getDevice().getDisplay() == null || this.configuration.getDevice().getDisplay().getDensity() == null) {
            return 0;
        }
        return this.configuration.getDevice().getDisplay().getDensity().getValue();
    }

    private double getDisplaySize() {
        if (this.configuration == null || this.configuration.getDevice() == null || this.configuration.getDevice().getDisplay() == null || this.configuration.getDevice().getDisplay().getScreenSize() == null) {
            return 0.0;
        }
        return this.configuration.getDevice().getDisplay().getScreenSize().getValue();
    }

    private String getSkinPath() {
        if (this.configuration == null || this.configuration.getDevice() == null || this.configuration.getDevice().getDisplay() == null || this.configuration.getDevice().getDisplay().getSkinPath() == null) {
            return null;
        }
        return this.configuration.getDevice().getDisplay().getSkinPath().getPath();
    }

    private int getCPUCount() {
        if (this.configuration == null || this.configuration.getDevice() == null || this.configuration.getDevice().getCPU() == null || this.configuration.getDevice().getCPU().getValue() == null) {
            return 1;
        }
        return this.configuration.getDevice().getCPU().getValue().getValue();
    }

    private int getRamSize() {
        if (this.configuration == null || this.configuration.getDevice() == null || this.configuration.getDevice().getRAM() == null || this.configuration.getDevice().getRAM().getSize() == null) {
            return 512;
        }
        return this.configuration.getDevice().getRAM().getSize().getValue();
    }

    private int getMaxTouchPoint() {
        if (this.configuration == null || this.configuration.getDevice() == null || this.configuration.getDevice().getTouch() == null) {
            return 10;
        }
        return this.configuration.getDevice().getTouch().getMaxTouchPoint();
    }

    private String getOciOptions() {
        if (this.configuration == null || this.configuration.getOci() == null) {
            return null;
        }
        return this.configuration.getOci().getOciOptions();
    }

    private List<VMOption> getAdvancedOptionList() {
        if (this.configuration == null || this.configuration.getAdvancedOption() == null) {
            return null;
        }
        List<VMOption> optionList = Collections.synchronizedList(new ArrayList());
        for (OptionType option : this.configuration.getAdvancedOption().getOption()) {
            VMOption o = new VMOption(option.getName());
            o.setValue(option.getValue());
            for (SubOptionType sub : option.getSubOption()) {
                VMOption s = new VMOption(sub.getName(), sub.getValue());
                o.addSubOption(s);
            }
            optionList.add(o);
        }
        return optionList;
    }

    private boolean isDiskImageNone() {
        return this.configuration == null || this.configuration.getBaseInformation() == null || this.configuration.getBaseInformation().getDiskImage() == null;
    }

    private boolean isBaseDiskImageNone() {
        return this.isDiskImageNone() || this.configuration.getBaseInformation().getDiskImage().getBaseDiskImage() == null;
    }

    private boolean isDeviceTemplateNone() {
        return this.configuration == null || this.configuration.getBaseInformation() == null || this.configuration.getBaseInformation().getDeviceTemplate() == null;
    }
}

