/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.console.processor;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Queue;
import org.tizen.emulator.manager.EmulatorManager;
import org.tizen.emulator.manager.console.resources.Messages;
import org.tizen.emulator.manager.console.util.OutputUtil;
import org.tizen.emulator.manager.devices.DeviceTemplate;
import org.tizen.emulator.manager.devices.DeviceTemplateList;
import org.tizen.emulator.manager.devices.DeviceTemplateValue;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.platform.PlatformList;
import org.tizen.emulator.manager.platform.Profile;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.tool.About;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.VMPropertyValue;
import org.tizen.emulator.manager.vms.exception.VMWorkerException;
import org.tizen.emulator.manager.vms.helper.HelperClass;

public class ConsoleProcessor {
    public Queue<VMProperty> getProperties() {
        return EmulatorManager.getVMKeeper().getProperties();
    }

    public VMProperty getProperty(String name) {
        return EmulatorManager.getVMKeeper().getProperty(name);
    }

    public void printAboutInfo() {
        OutputUtil.print("Emulator Manager");
        About about = About.getInstance();
        OutputUtil.printKeyandValue("Version", about.getVersion());
        OutputUtil.printKeyandValue("Build time", about.getBuildTime());
        OutputUtil.printKeyandValue("Git version", about.getGitVersion());
        OutputUtil.printKeyandValue("Workspace path", about.getWorkspacePath());
        OutputUtil.printKeyandValue("Package version", about.getPackageVersion());
    }

    public void printDetailOfVM(VMProperty prop) {
        try {
            VMPropertyValue value = prop.getPropertyValue();
            OutputUtil.print(value.vmName);
            OutputUtil.printKeyandValue("Platform", value.getPlatformName());
            if (value.getDeviceTemplate() == null) {
                OutputUtil.printKeyandValue("Template", "Not defined");
            } else {
                OutputUtil.printKeyandValue("Template", value.getDeviceTemplate().getValue().getName());
            }
            OutputUtil.printKeyandValue("Type", value.getImageType().toString());
            OutputUtil.printKeyandValue("CPU Arch", value.getImageArch().toString());
            OutputUtil.printKeyandValue("Resolution", value.resolution.getWidth() + "x" + value.resolution.getHeight());
            OutputUtil.printKeyandValue("Skin Path", value.skinPath == null ? "" : value.skinPath);
            OutputUtil.printKeyandValue("RAM Size", String.valueOf(value.ramSize));
            OutputUtil.printKeyandValue("CPU count", String.valueOf(value.cpu));
            String filePath = value.fileSharePath;
            if (filePath != null && !filePath.isEmpty()) {
                OutputUtil.printKeyandValue("File Sharing Path", filePath);
            }
        }
        catch (NullPointerException e) {
            OutputUtil.printError(e.getMessage());
        }
    }

    public void printDetailOfVM(String value) {
        VMProperty prop = this.getProperty(value);
        if (prop == null) {
            OutputUtil.printError(value + " " + Messages.getString("Detail.Error.NotExistVM"));
        } else {
            this.printDetailOfVM(prop);
        }
    }

    public int printVMList(Platform platform, boolean isDetail) {
        int count = 0;
        Queue<VMProperty> properties = this.getProperties();
        for (VMProperty prop : properties) {
            if (platform != null && prop.getPropertyValue().getPlatform() != null && !prop.getPropertyValue().getPlatform().equals(platform)) continue;
            this.printVM(prop, isDetail);
            ++count;
        }
        return count;
    }

    public int printVMList(Profile profile, boolean isDetail) {
        int count = 0;
        Queue<VMProperty> properties = this.getProperties();
        for (VMProperty prop : properties) {
            if (profile != null && !prop.getPropertyValue().getProfile().equals(profile.getName())) continue;
            this.printVM(prop, isDetail);
            ++count;
        }
        return count;
    }

    private void printVM(VMProperty prop, boolean isDetail) {
        if (!isDetail) {
            OutputUtil.print(prop.getPropertyValue().vmName);
        } else {
            this.printDetailOfVM(prop);
            OutputUtil.print("");
        }
    }

    public int getCountOfVMList() {
        return this.getProperties().size();
    }

    public int getCountOfVMList(Platform platform) {
        assert (platform != null);
        int i = 0;
        for (VMProperty prop : this.getProperties()) {
            if (!prop.getPropertyValue().getPlatform().equals(platform)) continue;
            ++i;
        }
        return i;
    }

    public int getCountOfVMList(Profile profile) {
        assert (profile != null);
        int i = 0;
        String profileName = profile.getName();
        for (VMProperty prop : this.getProperties()) {
            if (!prop.getPropertyValue().getProfile().equals(profileName)) continue;
            ++i;
        }
        return i;
    }

    private void printPlatform(Platform platform) {
        OutputUtil.print(platform.getName());
        OutputUtil.printKeyandValue("Profile", platform.getProfile().getName());
        OutputUtil.printKeyandValue("Version", platform.getVersion().getValue());
        OutputUtil.printKeyandValue("Image path", platform.getImagePathList().toString());
        OutputUtil.printKeyandValue("CPU Arch", platform.getImageArch().toString());
        OutputUtil.printKeyandValue("Skin shape", platform.getImageSkinShape().toString());
    }

    public int printPlatformList(Profile profile, boolean isDetail) {
        int count = 0;
        for (Platform platform : PlatformList.getList()) {
            if (profile != null && !platform.getProfile().equals(profile)) continue;
            ++count;
            if (isDetail) {
                this.printPlatform(platform);
                OutputUtil.print("");
                continue;
            }
            OutputUtil.print(platform.getName());
        }
        return count;
    }

    private void printDevice(DeviceTemplate device) {
        DeviceTemplateValue value = device.getValue();
        OutputUtil.print(value.getName());
        OutputUtil.printKeyandValue("Profile", value.getProfile());
        OutputUtil.printKeyandValue("Resolution", value.getDisplayWidth() + "x" + value.getDisplayHeight());
        OutputUtil.printKeyandValue("Skin shape", value.getSkinShape().toString());
        OutputUtil.printKeyandValue("Skin Path", value.getSkinPath() == null ? "" : value.getSkinPath());
        OutputUtil.printKeyandValue("RAM Size", String.valueOf(value.getRamSize()));
        OutputUtil.printKeyandValue("CPU count", String.valueOf(value.getCpuCount()));
    }

    public int printDeviceList(Profile profile, boolean isDetail) {
        String profileName = profile == null ? "" : profile.getName();
        int count = 0;
        for (DeviceTemplate device : DeviceTemplateList.getDeviceTemplateList(false)) {
            if (!profileName.isEmpty() && !device.getValue().getProfile().equals(profileName)) continue;
            ++count;
            if (isDetail) {
                this.printDevice(device);
                OutputUtil.print("");
                continue;
            }
            OutputUtil.print(device.getValue().getName());
        }
        return count;
    }

    public boolean launchEmulator(String name, String path, List<String> addVariables) {
        VMProperty prop = this.getProperty(name);
        if (prop == null) {
            OutputUtil.printError(name + " " + Messages.getString("Launch.Error.NotExistVM"));
            return false;
        }
        if (path != null) {
            try {
                File f = new File(path).getCanonicalFile();
                if (!f.exists()) {
                    OutputUtil.printError(Messages.getString("Launch.Error.NotExistPath"), "Path: " + f.getAbsolutePath());
                    return false;
                }
                path = f.getAbsolutePath();
            }
            catch (IOException e) {
                OutputUtil.printError(e.getMessage());
                return false;
            }
        }
        try {
            prop.getWorker().launchVM(true, path, addVariables);
        }
        catch (VMWorkerException e) {
            OutputUtil.printError(Messages.getString("Launch.Error.Exception"), e.getMessage());
            return false;
        }
        OutputUtil.print(Messages.getString("Launch.Success"));
        return true;
    }

    public boolean deleteVM(String name) {
        VMProperty prop = this.getProperty(name);
        if (prop == null) {
            OutputUtil.printError(name + " " + Messages.getString("Delete.Error.NotExistVM"));
            return false;
        }
        try {
            if (!prop.getWorker().deleteVM()) {
                OutputUtil.print(Messages.getString("Delete.Warning.DeleteDir.1"));
                OutputUtil.print(Messages.getString("Delete.Warning.DeleteDir.2"));
                OutputUtil.print(Messages.getString("Delete.Warning.DeleteDir.3") + FilePathResources.getTizenSDKDataVmsPath() + File.separator + name);
            }
        }
        catch (VMWorkerException e) {
            OutputUtil.printError(e.getMessage());
            return false;
        }
        OutputUtil.print(Messages.getString("Delete.Success"));
        return true;
    }

    public boolean resetVM(String name) {
        VMProperty prop = this.getProperty(name);
        if (prop == null) {
            OutputUtil.printError(name + " " + Messages.getString("Reset.Error.NotExistVM"));
            return false;
        }
        try {
            prop.getWorker().resetVM();
        }
        catch (VMWorkerException e) {
            OutputUtil.printError(e.getMessage());
            return false;
        }
        OutputUtil.print(Messages.getString("Reset.Success"));
        return true;
    }

    public boolean createBaseIamge(String name, String path, boolean useCompress) {
        VMProperty prop = this.getProperty(name);
        if (prop == null) {
            OutputUtil.printError(name + " " + Messages.getString("Export.Error.NotExistVM"));
            return false;
        }
        File f = new File(path);
        if (!f.exists()) {
            OutputUtil.printError(Messages.getString("Export.Error.NotExistPath"), "Path: " + path);
            return false;
        }
        try {
            if (f.isDirectory()) {
                path = path + File.separator + "emulimg-" + name + "." + prop.getPropertyValue().getImageArch().toString();
            }
            OutputUtil.print(Messages.getString("Export.Wait"));
            prop.getWorker().createNewBaseImage(prop, path, useCompress);
        }
        catch (VMWorkerException e) {
            OutputUtil.printError(e.getMessage());
            return false;
        }
        OutputUtil.print("");
        OutputUtil.print(Messages.getString("Export.Success"));
        OutputUtil.print("Path: " + path);
        return true;
    }

    public boolean cloneVM(String name, String target) {
        VMProperty prop = this.getProperty(name);
        if (prop == null) {
            System.out.println(Messages.getString("ConsoleProcessor.NotExistVMError.2") + name);
            return false;
        }
        if (!HelperClass.checkDuplicateName(target)) {
            System.out.println(Messages.getString("ConsoleProcessor.DupulicateNameError.0") + target + Messages.getString("ConsoleProcessor.DupulicateNameError.1"));
            return false;
        }
        try {
            prop.getWorker().cloneVM(target);
        }
        catch (VMWorkerException e) {
            System.out.println("Error: " + e.getMessage());
            return false;
        }
        System.out.println(Messages.getString("ConsoleProcessor.SuccessColne.0"));
        return true;
    }
}

