/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.create;

import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.tizen.emulator.manager.platform.Profile;
import org.tizen.emulator.manager.ui.controller.vms.ROW_STATE;
import org.tizen.emulator.manager.ui.resources.ImageKind;
import org.tizen.emulator.manager.ui.resources.Images;

public class ProfileListItem {
    private final Label label;
    private final SimpleObjectProperty<ROW_STATE> state = new SimpleObjectProperty();
    private final String profile;
    private final SimpleStringProperty selected;
    private static final String TEXT_FILL_NORMAL = "#585858";
    private static final String TEXT_FILL_OVER = "#333333";
    private static final String TEXT_FILL_SELECTED = "#008aee";

    public ProfileListItem(Profile p, SimpleStringProperty selected) {
        ImageView icon = null;
        this.profile = p.getName();
        if (this.profile.equals("mobile")) {
            icon = new ImageView(Images.get(ImageKind.PROFILE_BUTTON_MOBILE));
        } else if (this.profile.equals("wearable")) {
            icon = new ImageView(Images.get(ImageKind.PROFILE_BUTTON_WEARABLE));
        } else if (this.profile.equals("tv")) {
            icon = new ImageView(Images.get(ImageKind.PROFILE_BUTTON_TV));
        }
        this.label = new Label(p.getName());
        this.label.setGraphic((Node)icon);
        this.label.getStyleClass().add((Object)"profile-content-label");
        this.addStateChangeListener();
        this.addMouseListener();
        this.selected = selected;
    }

    public String getProfile() {
        return this.profile;
    }

    public Node getContent() {
        return this.label;
    }

    public void setSelected() {
        this.state.set((Object)ROW_STATE.SELECTED);
        this.selected.set(this.profile);
    }

    public void setNormal() {
        this.state.set((Object)ROW_STATE.NORMAL);
    }

    private void addMouseListener() {
        this.label.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                Bounds bound = ProfileListItem.this.label.getBoundsInLocal();
                if (e.getX() > 0.0 && e.getX() < bound.getWidth() && e.getY() > 0.0 && e.getY() < bound.getHeight()) {
                    ProfileListItem.this.setSelected();
                }
            }
        });
        this.label.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                if (ProfileListItem.this.state.get() == ROW_STATE.SELECTED) {
                    return;
                }
                ProfileListItem.this.state.set((Object)ROW_STATE.OVER);
            }
        });
        this.label.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                if (ProfileListItem.this.state.get() == ROW_STATE.SELECTED) {
                    return;
                }
                ProfileListItem.this.state.set((Object)ROW_STATE.NORMAL);
            }
        });
    }

    private void addStateChangeListener() {
        this.state.addListener((ChangeListener)new ChangeListener<ROW_STATE>(){

            public void changed(ObservableValue<? extends ROW_STATE> arg, ROW_STATE oldValue, ROW_STATE newValue) {
                ImageView icon = null;
                switch (newValue) {
                    case NORMAL: {
                        if (ProfileListItem.this.profile.equals("mobile")) {
                            icon = new ImageView(Images.get(ImageKind.PROFILE_BUTTON_MOBILE));
                        } else if (ProfileListItem.this.profile.equals("wearable")) {
                            icon = new ImageView(Images.get(ImageKind.PROFILE_BUTTON_WEARABLE));
                        } else if (ProfileListItem.this.profile.equals("tv")) {
                            icon = new ImageView(Images.get(ImageKind.PROFILE_BUTTON_TV));
                        }
                        ProfileListItem.this.label.setTextFill((Paint)Color.web((String)ProfileListItem.TEXT_FILL_NORMAL));
                        break;
                    }
                    case OVER: {
                        if (ProfileListItem.this.profile.equals("mobile")) {
                            icon = new ImageView(Images.get(ImageKind.PROFILE_BUTTON_MOBILE_OVER));
                        } else if (ProfileListItem.this.profile.equals("wearable")) {
                            icon = new ImageView(Images.get(ImageKind.PROFILE_BUTTON_WEARABLE_OVER));
                        } else if (ProfileListItem.this.profile.equals("tv")) {
                            icon = new ImageView(Images.get(ImageKind.PROFILE_BUTTON_TV_OVER));
                        }
                        ProfileListItem.this.label.setTextFill((Paint)Color.web((String)ProfileListItem.TEXT_FILL_OVER));
                        break;
                    }
                    case SELECTED: {
                        if (ProfileListItem.this.profile.equals("mobile")) {
                            icon = new ImageView(Images.get(ImageKind.PROFILE_BUTTON_MOBILE_SEL));
                        } else if (ProfileListItem.this.profile.equals("wearable")) {
                            icon = new ImageView(Images.get(ImageKind.PROFILE_BUTTON_WEARABLE_SEL));
                        } else if (ProfileListItem.this.profile.equals("tv")) {
                            icon = new ImageView(Images.get(ImageKind.PROFILE_BUTTON_TV_SEL));
                        }
                        ProfileListItem.this.label.setTextFill((Paint)Color.web((String)ProfileListItem.TEXT_FILL_SELECTED));
                        break;
                    }
                }
                ProfileListItem.this.label.setGraphic(icon);
            }
        });
    }
}

