/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.item;

import org.tizen.emulator.manager.devices.DeviceTemplate;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.platform.Skin;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.vms.VMPropertyValue;
import org.tizen.emulator.manager.vms.type.RESOLUTION;

public class VMValue
implements PropertyValue {
    private final VMPropertyValue vmValue;

    public VMValue(VMPropertyValue propertyValue) {
        this.vmValue = propertyValue;
    }

    @Override
    public Integer getIntegerValue(String name) {
        if (name.equals("ramSize")) {
            return this.vmValue.ramSize;
        }
        if (name.equals("processors")) {
            return this.vmValue.cpu;
        }
        if (name.equals("maxTouch")) {
            return this.vmValue.maxTouchCount;
        }
        return null;
    }

    @Override
    public Double getDoubleValue(String name) {
        if (name.equals("size")) {
            return this.vmValue.screenSize;
        }
        return null;
    }

    @Override
    public Boolean getBooleanValue(String name) {
        if (name.equals("cpu")) {
            return this.vmValue.isHWVirtualization;
        }
        if (name.equals("gpu")) {
            return this.vmValue.isGLAcceleration;
        }
        if (name.equals("fileShare")) {
            return this.vmValue.isFileShareSupport;
        }
        if (name.equals("suspendSupport")) {
            return this.vmValue.isSupportSuspend;
        }
        if (name.equals("baseImage")) {
            return this.vmValue.isStandardImage();
        }
        return null;
    }

    @Override
    public Object getObjectValue(String name) {
        if (name.equals("deviceTemplate")) {
            return this.vmValue.getDeviceTemplate();
        }
        if (name.equals("baseImage")) {
            return this.vmValue.getPlatform();
        }
        if (name.equals("skin")) {
            return this.vmValue.skin;
        }
        if (name.equals("resolution")) {
            return this.vmValue.resolution;
        }
        if (name.equals("SkinList")) {
            return this.vmValue.getPlatform().getSkinList();
        }
        if (name.equals("skinShape")) {
            return this.vmValue.getPlatform().getImageSkinShape();
        }
        return null;
    }

    @Override
    public String getStringValue(String name) {
        if (name.equals("deviceTemplate") || name.equals("template-name")) {
            return this.vmValue.deviceName;
        }
        if (name.equals("baseImage") || name.equals("platform")) {
            return this.vmValue.getPlatformName();
        }
        if (name.equals("skin")) {
            return this.vmValue.skin.getName();
        }
        if (name.equals("skinPath")) {
            return this.vmValue.skinPath;
        }
        if (name.equals("fileShare")) {
            return this.vmValue.fileSharePath;
        }
        if (name.equals("profile")) {
            return this.vmValue.getProfile();
        }
        if (name.equals("vmName") || name.equals("name")) {
            return this.vmValue.vmName;
        }
        if (name.equals("processors")) {
            return String.valueOf(this.vmValue.cpu);
        }
        if (name.equals("ramSize")) {
            return String.valueOf(this.vmValue.ramSize) + " MiB";
        }
        if (name.equals("resolution")) {
            return this.vmValue.resolution.toString();
        }
        if (name.equals("size")) {
            return String.valueOf(this.vmValue.screenSize) + "inch" + " (DPI: " + String.valueOf(this.vmValue.dpi) + ")";
        }
        if (name.equals("cpu")) {
            return this.vmValue.isHWVirtualization ? "ON" : "OFF";
        }
        if (name.equals("gpu")) {
            return this.vmValue.isGLAcceleration ? "ON" : "OFF";
        }
        if (name.equals("inputDevice")) {
            return this.vmValue.maxTouchCount == 0 ? "Mouse" : "Touch";
        }
        return this.vmValue.getAdvancedOptionValue(name);
    }

    @Override
    public String getSubItemStringValue(String parentName, String subItemName) {
        return this.vmValue.getAdvancedSubOptionValue(parentName, subItemName);
    }

    @Override
    public void setIntegerValue(String name, Integer value) {
        if (name.equals("ramSize")) {
            this.vmValue.ramSize = value;
        } else if (name.equals("processors")) {
            this.vmValue.cpu = value;
        } else if (name.equals("maxTouch")) {
            this.vmValue.maxTouchCount = value;
        }
    }

    @Override
    public void setDoubleValue(String name, Double value) {
        if (name.equals("size")) {
            this.vmValue.screenSize = value;
        }
    }

    @Override
    public void setBooleanValue(String name, Boolean value) {
        if (name.equals("cpu")) {
            this.vmValue.isHWVirtualization = value;
        } else if (name.equals("gpu")) {
            this.vmValue.isGLAcceleration = value;
        } else if (name.equals("fileShare")) {
            this.vmValue.isFileShareSupport = value;
        } else if (name.equals("suspendSupport")) {
            this.vmValue.isSupportSuspend = value;
        }
    }

    @Override
    public void setObjectValue(String name, Object value) {
        if (name.equals("deviceTemplate")) {
            this.vmValue.setDeviceTemplate((DeviceTemplate)value);
        } else if (name.equals("baseImage")) {
            this.vmValue.setPlatform((Platform)value);
        } else if (name.equals("skin")) {
            this.vmValue.skin = (Skin)value;
        } else if (name.equals("resolution")) {
            this.vmValue.resolution = (RESOLUTION)value;
        }
    }

    @Override
    public void setStringValue(String name, String value) {
        if (name.equals("deviceTemplate")) {
            this.vmValue.deviceName = value;
        } else if (name.equals("skin")) {
            this.vmValue.skinPath = value;
        } else if (name.equals("fileShare")) {
            this.vmValue.fileSharePath = value;
            this.vmValue.isFileShareSupport = value != null && !value.isEmpty();
        } else if (name.equals("vmName") || name.equals("name")) {
            this.vmValue.vmName = value;
        } else if (name.equals("inputDevice")) {
            this.vmValue.maxTouchCount = value.equals("Mouse") ? 0 : 10;
        } else {
            this.vmValue.setAdvancedOption(name, value);
        }
    }

    @Override
    public void setSubItemStringValue(String parentName, String subItemName, String value) {
        this.vmValue.setAdvancedSubOption(parentName, subItemName, value);
    }

    @Override
    public Object getData() {
        return this.vmValue;
    }

    @Override
    public void setSubItemBooleanValue(String parentName, String subItemName, boolean value) {
    }
}

