/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.controller;

import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.item.NetTCPIPLabelViewItem;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;
import org.tizen.emulator.manager.ui.template.item.Item;
import org.tizen.emulator.manager.vms.helper.HelperClass;

public class NetTCPIPLabelController
extends ViewItemController {
    private NetTCPIPLabelViewItem viewItem;

    public NetTCPIPLabelController(Item item, ViewItemController parent) {
        super(item, parent);
    }

    @Override
    public void makeViewItem() {
        this.setViewItem(new NetTCPIPLabelViewItem());
    }

    @Override
    public ViewItem getViewItem() {
        return this.viewItem;
    }

    @Override
    public void setViewItem(ViewItem item) {
        this.viewItem = item instanceof NetTCPIPLabelViewItem ? (NetTCPIPLabelViewItem)item : new NetTCPIPLabelViewItem();
        this.viewItem.setTitle("VM IP info");
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        String mac;
        String dns;
        String gateway;
        String subnet;
        String type = value.getStringValue("netConnectType");
        if (type == null || type.isEmpty()) {
            type = "NAT";
        }
        if (type.equals("NAT")) {
            this.viewItem.hideIPInfo(true);
            return;
        }
        this.viewItem.hideIPInfo(false);
        String check = value.getSubItemStringValue("netIpInfo", "useDHCP");
        String ip = value.getSubItemStringValue("netIpInfo", "ipAddr");
        if (ip == null) {
            ip = "";
        }
        if ((subnet = value.getSubItemStringValue("netIpInfo", "subnet")) == null) {
            subnet = "";
        }
        if ((gateway = value.getSubItemStringValue("netIpInfo", "gateway")) == null) {
            gateway = "";
        }
        if ((dns = value.getStringValue("netDns")) == null) {
            dns = "";
        }
        if ((mac = value.getStringValue("netMac")) == null || mac.isEmpty()) {
            mac = HelperClass.getMacAddress();
        }
        this.viewItem.setCheck(check.equals("on"));
        this.viewItem.setIP(ip, subnet, gateway);
        this.viewItem.setDNS(dns);
        this.viewItem.setMAC(mac);
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
    }

    @Override
    public void checkValid() {
    }
}

