/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.devicetemplate.controller;

import org.tizen.emulator.manager.devices.DeviceTemplateValue;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.ui.Messages;
import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.STATE;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.item.TextViewItem;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;
import org.tizen.emulator.manager.ui.template.item.Item;
import org.tizen.emulator.manager.vms.helper.HelperClass;

public class TemplateNameViewController
extends ViewItemController {
    private TextViewItem textView;
    private Platform platform;

    public TemplateNameViewController(Item item) {
        super(item);
    }

    @Override
    public void makeViewItem() {
        this.setViewItem(new TextViewItem());
    }

    @Override
    public ViewItem getViewItem() {
        return this.textView;
    }

    @Override
    public void setViewItem(ViewItem item) {
        this.textView = item instanceof TextViewItem ? (TextViewItem)item : new TextViewItem();
        this.textView.setMaxLen(30);
        this.textView.setMatchStr("[A-Za-z0-9-_()]");
        this.textView.setTitle(this.getTitle());
        this.textView.addEventHandler(EventType.Modify, new EventHandler<Event>(){

            @Override
            public void handleEvent(Event event) {
                TemplateNameViewController.this.checkValid();
            }
        });
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        this.platform = (Platform)value.getObjectValue("platform");
        if (this.getMode() == MODE.CREATE) {
            this.textView.setText(HelperClass.getDefaultTemplateName((DeviceTemplateValue)value.getData(), this.platform));
        } else if (this.getMode() == MODE.CLONE) {
            this.textView.setText(HelperClass.getCloneTemplateName((DeviceTemplateValue)value.getData(), this.platform));
        } else {
            String text = value.getStringValue(this.getName());
            this.textView.setText(text);
            this.textView.setEnable(false);
        }
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        value.setStringValue(this.getName(), this.textView.getText());
    }

    @Override
    public void checkValid() {
        STATE newState;
        if (this.mode == MODE.MODIFY) {
            return;
        }
        String newName = this.textView.getText();
        String errorMsg = "";
        if (newName.length() > 30) {
            errorMsg = Messages.getString("VMNameViewItem.NameError.0");
            newState = STATE.ERROR;
        } else if (newName.isEmpty()) {
            errorMsg = Messages.getString("VMNameViewItem.NameError.6");
            newState = STATE.ESSENTIAL;
        } else if (!HelperClass.checkDuplicateTemplateName(newName, this.platform)) {
            errorMsg = Messages.getString("VMNameViewItem.NameError.2");
            newState = STATE.ERROR;
        } else {
            newState = STATE.OK;
        }
        if (newState != STATE.OK) {
            this.textView.setState(newState, errorMsg);
        } else if (this.state != STATE.OK) {
            this.textView.setState(newState, "");
        }
        if (newState != this.state) {
            this.setState(newState);
        }
    }

    @Override
    protected void onChangedValue(Event event) {
    }
}

