/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.controller;

import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.tabview.item.ToggleButtonViewItem;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;
import org.tizen.emulator.manager.ui.template.item.Item;

public class ToggleButtonController
extends ViewItemController {
    protected ToggleButtonViewItem button;

    public ToggleButtonController(Item item) {
        super(item);
    }

    public ToggleButtonController(Item item, ViewItemController parent) {
        super(item, parent);
    }

    @Override
    public void makeViewItem() {
        this.setViewItem(new ToggleButtonViewItem());
    }

    @Override
    public ViewItem getViewItem() {
        return this.button;
    }

    @Override
    public void setViewItem(ViewItem item) {
        this.button = item instanceof ToggleButtonViewItem ? (ToggleButtonViewItem)item : new ToggleButtonViewItem();
        this.button.setTitle(this.getTitle());
        this.button.addEventHandler(EventType.Selection, new EventHandler<Event>(){

            @Override
            public void handleEvent(Event event) {
                ToggleButtonController.this.onChangedValue(event);
            }
        });
    }

    @Override
    protected void onChangedValue(Event event) {
        ItemEvent iEvent = new ItemEvent(this.getName(), this);
        iEvent.oldValue = "";
        iEvent.newValue = String.valueOf(this.button.isSelected());
        iEvent.oldState = this.state;
        iEvent.newState = this.state;
        ViewItemController.sendChangeEvent(iEvent);
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        Boolean isOn = value.getBooleanValue(this.getName());
        if (isOn != null) {
            this.button.setSelected(isOn);
        }
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        value.setBooleanValue(this.getName(), this.button.isSelected());
    }

    @Override
    public void checkValid() {
    }
}

