/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.platform;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import org.tizen.emulator.manager.devices.DeviceTemplate;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.platform.DummyPlatform;
import org.tizen.emulator.manager.platform.PlatformList;
import org.tizen.emulator.manager.platform.Profile;
import org.tizen.emulator.manager.platform.Skin;
import org.tizen.emulator.manager.platform.StandardPlatform;
import org.tizen.emulator.manager.platform.StandardPlatformImageValue;
import org.tizen.emulator.manager.platform.Version;
import org.tizen.emulator.manager.platform.custom.CustomPlatform;
import org.tizen.emulator.manager.platform.custom.CustomPlatformImageValue;
import org.tizen.emulator.manager.platform.custom.TemporaryCustomPlatform;
import org.tizen.emulator.manager.plugin.EMPlugin;
import org.tizen.emulator.manager.vms.DiskImageFormat;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.type.Architecture;
import org.tizen.emulator.manager.vms.type.RESOLUTION;
import org.tizen.emulator.manager.vms.type.SKIN_SHAPE;

public abstract class Platform
implements Comparable<Platform> {
    private State state = State.WELL;
    private static String IMAGE_TYPE_DEFAULT = "default";
    private String platformName;
    private String imageName = "";
    private final List<String> imageFileNameList = new ArrayList<String>();
    private final List<String> imagePathList = new ArrayList<String>();
    private final DiskImageFormat imageFormat;
    private String type;
    private String description = "";
    private Object data = null;

    public static Platform createStandardInstance(File imageDir, EMPlugin plugin) {
        if (imageDir == null || plugin == null) {
            return null;
        }
        StandardPlatformImageValue value = StandardPlatformImageValue.createInstance(imageDir);
        if (value == null) {
            return null;
        }
        if (!value.getProfile().equals(plugin.getProfile().getName())) {
            EMLogger.getLogger().warning("Profile of base image(" + value.getProfile() + ") does not equal profile of platform(" + plugin.getProfile() + ").");
            return null;
        }
        if (!value.getVersion().equals(plugin.getVersion().getValue())) {
            EMLogger.getLogger().warning("Version of base image(" + value.getVersion() + ") does not equal version of platform(" + plugin.getVersion() + ").");
            return null;
        }
        StandardPlatform platform = new StandardPlatform(value, plugin);
        PlatformList.add(platform);
        return platform;
    }

    public static Platform createCustomInstance(CustomPlatformImageValue value) {
        if (value == null || value.getPlatform() == null) {
            return null;
        }
        CustomPlatform platform = new CustomPlatform(value);
        if (value.getImageFormat() == DiskImageFormat.QCOW2) {
            PlatformList.add(platform);
        }
        return platform;
    }

    public static Platform createTemporaryCustomInstance(CustomPlatformImageValue value) {
        if (value == null || value.getPlatform() == null) {
            return null;
        }
        TemporaryCustomPlatform platform = new TemporaryCustomPlatform(value);
        return platform;
    }

    public static Platform createDummyPlatform(String profile, String platformName, String type, String arch) {
        CustomPlatformImageValue value = new CustomPlatformImageValue();
        value.setPlatformName(platformName);
        value.setProfile(profile);
        value.setType(type);
        DummyPlatform platform = new DummyPlatform(value);
        platform.setArch(arch);
        return platform;
    }

    protected Platform(DiskImageFormat format) {
        this.imageFormat = format;
    }

    public void setState(State state) {
        this.state = state;
    }

    public State getState() {
        return this.state;
    }

    public boolean isNotAvailabale() {
        return this.state == State.NOT_AVAILABLE;
    }

    protected void setName(String name) {
        this.platformName = name;
    }

    public String getName() {
        return this.platformName;
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public DiskImageFormat getImageFormat() {
        return this.imageFormat;
    }

    protected void addImagePath(String path) {
        if (this.imagePathList.contains(path) || path.isEmpty()) {
            return;
        }
        this.imagePathList.add(path);
        this.imageFileNameList.add(path.substring(path.lastIndexOf(File.separator) + 1));
    }

    @Deprecated
    public String getImagePath() {
        return "";
    }

    public List<String> getImagePathList() {
        return this.imagePathList;
    }

    public List<String> getImageFileNameList() {
        return this.imageFileNameList;
    }

    @Deprecated
    public String getImageFileName() {
        if (this.imageFileNameList.isEmpty()) {
            return "";
        }
        return this.imageFileNameList.get(0);
    }

    protected void setImageType(String type) {
        this.type = type;
    }

    String getImageType() {
        return this.type;
    }

    protected void setImageDescription(String description) {
        this.description = description;
    }

    public String getImageDescription() {
        return this.description;
    }

    public boolean isImageExist() {
        for (String path : this.imagePathList) {
            File file = new File(path);
            if (file.exists()) continue;
            return false;
        }
        return true;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        assert (data != null);
        this.data = data;
    }

    public String toString() {
        return this.getName();
    }

    public abstract Architecture getImageArch();

    public abstract SKIN_SHAPE getImageSkinShape();

    public abstract String getImageBinaryVersion();

    public abstract String getPlatformPath();

    public abstract Profile getProfile();

    public abstract Version getVersion();

    public abstract String getExtension();

    public abstract String getEmulatorDirPath();

    public abstract EMPlugin getPlugin();

    public abstract List<Skin> getSkinList();

    public abstract Skin getSkinByPath(String var1);

    public abstract Skin getSkinByName(String var1);

    public abstract List<Skin> getSkinList(RESOLUTION var1);

    public abstract Skin getAvailableSkin(RESOLUTION var1);

    public abstract VMProperty getDefaultProperty();

    public abstract void loadDeviceTemplates();

    public abstract SortedSet<DeviceTemplate> getAvailableDeviceTemplates();

    public abstract SortedSet<DeviceTemplate> getDeviceTemplates();

    public void printInformation() {
        System.out.println("Platform Name: " + this.platformName);
        System.out.println("Type: " + this.type);
        System.out.println("Arch: " + (Object)((Object)this.getImageArch()));
        System.out.println("Skin shape: " + (Object)((Object)this.getImageSkinShape()));
        System.out.println("Image Path: " + this.imagePathList);
    }

    @Deprecated
    public String getEmulatorPath() {
        return "";
    }

    @Override
    public int compareTo(Platform target) {
        int compare;
        if (this.equals(target)) {
            return 0;
        }
        if (this instanceof StandardPlatform) {
            if (target instanceof CustomPlatform) {
                return -1;
            }
        } else if (target instanceof StandardPlatform) {
            return 1;
        }
        if ((compare = this.getProfile().compareTo(target.getProfile())) != 0) {
            return compare;
        }
        compare = target.getVersion().compareTo(this.getVersion());
        if (compare != 0) {
            return compare;
        }
        compare = Boolean.valueOf(target.getExtension().isEmpty()).compareTo(this.getExtension().isEmpty());
        if (compare != 0) {
            return compare;
        }
        compare = this.getImageArch().compareTo(target.getImageArch());
        if (compare != 0) {
            return compare;
        }
        if (this.getImageType().equals(IMAGE_TYPE_DEFAULT)) {
            if (!target.getImageType().equals(IMAGE_TYPE_DEFAULT)) {
                return -1;
            }
        } else if (target.getImageType().equals(IMAGE_TYPE_DEFAULT)) {
            return 1;
        }
        if ((compare = target.getImageSkinShape().compareTo(this.getImageSkinShape())) != 0) {
            return compare;
        }
        return this.platformName.compareTo(target.platformName);
    }

    public static enum State {
        WELL,
        NOT_AVAILABLE;

    }
}

