/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.tool;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.tizen.emulator.manager.concurrent.NoExceptionCallable;
import org.tizen.emulator.manager.concurrent.SimpleExecutor;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.resources.StringResources;

public class JAXBHelper {
    public static <T> T parseXML(final Path inputPath, final Class<T> type) {
        return SimpleExecutor.lockedExecute(new NoExceptionCallable<T>(){

            @Override
            public T call() {
                return JAXBHelper.parseXMLLocked(inputPath, type);
            }
        });
    }

    public static boolean storeXML(final Path outputPath, final Object conf) {
        return SimpleExecutor.lockedExecute(new NoExceptionCallable<Boolean>(){

            @Override
            public Boolean call() {
                return JAXBHelper.storeXMLLocked(outputPath, conf);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T parseXMLLocked(Path inputPath, Class<T> type) {
        JAXBElement element = null;
        JAXBContext context = null;
        try {
            context = JAXBContext.newInstance((Class[])new Class[]{type});
        }
        catch (JAXBException e) {
            EMLogger.getLogger().warning(e.getMessage());
            return null;
        }
        AbstractInterruptibleChannel fc = null;
        while (fc == null && Files.isRegularFile(inputPath, new LinkOption[0])) {
            try {
                fc = FileChannel.open(inputPath, StandardOpenOption.READ, StandardOpenOption.WRITE);
            }
            catch (FileSystemException e) {
                EMLogger.getLogger().warning(e.getMessage());
            }
            catch (IOException e) {
                EMLogger.getLogger().warning(e.getMessage());
            }
        }
        if (fc == null) {
            EMLogger.getLogger().warning("Failed to open config file - " + inputPath);
            return null;
        }
        InputStream is = null;
        try {
            is = Channels.newInputStream(fc);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            element = unmarshaller.unmarshal((Source)new StreamSource(is), type);
        }
        catch (OverlappingFileLockException e) {
            EMLogger.printStackTrace(e);
            assert (false);
        }
        catch (JAXBException e) {
            EMLogger.getLogger().warning(e.getMessage());
            EMLogger.getLogger().warning("Failed to load config file - " + inputPath + StringResources.NEW_LINE + e.getMessage());
            element = null;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                EMLogger.getLogger().warning(e.getMessage());
            }
            try {
                if (fc.isOpen()) {
                    fc.close();
                }
            }
            catch (IOException e) {
                EMLogger.getLogger().warning(e.getMessage());
            }
        }
        if (element != null) {
            return (T)element.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean storeXMLLocked(Path outputPath, Object conf) {
        JAXBContext context = null;
        try {
            context = JAXBContext.newInstance((Class[])new Class[]{conf.getClass()});
        }
        catch (JAXBException e) {
            EMLogger.getLogger().warning(e.getMessage());
            return false;
        }
        FileChannel fc = null;
        try {
            fc = FileChannel.open(outputPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            if (fc == null) {
                return false;
            }
        }
        catch (IOException e) {
            EMLogger.getLogger().warning("Failed to create config file - " + outputPath + StringResources.NEW_LINE + e.getMessage());
            return false;
        }
        OutputStream os = null;
        try {
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            os = Channels.newOutputStream(fc);
            marshaller.marshal(conf, os);
        }
        catch (JAXBException e) {
            EMLogger.getLogger().warning("Failed to save config file - " + outputPath + StringResources.NEW_LINE + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                EMLogger.getLogger().warning(e.getMessage());
            }
            try {
                if (fc.isOpen()) {
                    fc.close();
                }
            }
            catch (IOException e) {
                EMLogger.getLogger().warning(e.getMessage());
            }
        }
        return true;
    }
}

