/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.option;

import java.util.ArrayList;
import java.util.List;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.vms.VMOption;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.VMPropertyValue;
import org.tizen.emulator.manager.vms.option.BaseImageOption;
import org.tizen.emulator.manager.vms.option.CPUSupportOption;
import org.tizen.emulator.manager.vms.option.CameraLegacyOption;
import org.tizen.emulator.manager.vms.option.CommonOptionFactory;
import org.tizen.emulator.manager.vms.option.ConnectivityOption;
import org.tizen.emulator.manager.vms.option.DisplayOption;
import org.tizen.emulator.manager.vms.option.FileShareOption;
import org.tizen.emulator.manager.vms.option.FrontCameraOption;
import org.tizen.emulator.manager.vms.option.GLVersionOption;
import org.tizen.emulator.manager.vms.option.GPUSupportOption;
import org.tizen.emulator.manager.vms.option.IOption;
import org.tizen.emulator.manager.vms.option.IOptionFactory;
import org.tizen.emulator.manager.vms.option.NetProxyOption;
import org.tizen.emulator.manager.vms.option.NetworkOption;
import org.tizen.emulator.manager.vms.option.Option;
import org.tizen.emulator.manager.vms.option.ProcessorOption;
import org.tizen.emulator.manager.vms.option.RamSizeOption;
import org.tizen.emulator.manager.vms.option.RearCameraOption;
import org.tizen.emulator.manager.vms.option.SensorOption;
import org.tizen.emulator.manager.vms.option.SuspendSupportOption;
import org.tizen.emulator.manager.vms.option.VMNameOption;

public class CommonOptionUtil {
    public static List<IOption> getOptionList(Platform platform) {
        return CommonOptionUtil.getOptionList(platform, null);
    }

    public static List<IOption> getOptionList(Platform platform, VMPropertyValue value) {
        ArrayList<IOption> optionList = new ArrayList();
        IOptionFactory f = null;
        if (platform.getPlugin() != null) {
            f = (IOptionFactory)platform.getPlugin().newInstance("Option-Factory-v2");
        }
        if (f == null) {
            f = new CommonOptionFactory();
            EMLogger.getLogger().warning("Fail to load OptionFactory.");
            EMLogger.getLogger().info("Use CommonOptionFactory.");
        }
        optionList = f.internalOptionList(CommonOptionUtil.getOptionItemList(platform, value));
        return optionList;
    }

    public static List<String> getOptionItemList(Platform platform) {
        return CommonOptionUtil.getOptionItemList(platform, null);
    }

    public static List<String> getOptionItemList(Platform platform, VMPropertyValue propValue) {
        ArrayList<String> optionItemList = new ArrayList<String>();
        VMPropertyValue value = propValue;
        if (propValue == null) {
            VMProperty defaultProp = platform.getDefaultProperty();
            if (defaultProp == null) {
                EMLogger.getLogger().warning("No default property found");
                return optionItemList;
            }
            value = defaultProp.getPropertyValue();
        }
        optionItemList.add("name");
        optionItemList.add("baseImage");
        optionItemList.add("hwSupport");
        optionItemList.add("suspendSupport");
        optionItemList.add("fileShare");
        optionItemList.add("display");
        optionItemList.add("processors");
        optionItemList.add("ramSize");
        CommonOptionUtil.setAdvancedOption(value.getAdvancedOptionList(), optionItemList);
        return optionItemList;
    }

    private static void setAdvancedOption(List<VMOption> vmOptionList, List<String> optionList) {
        for (VMOption item : vmOptionList) {
            optionList.add(item.getName());
            if (item.getSubOptionList() == null) continue;
            CommonOptionUtil.setAdvancedOption(item.getSubOptionList(), optionList);
        }
    }

    public static void addOption(List<IOption> optionList, String itemName) {
        if (itemName.equals("name") || itemName.equals("vmName")) {
            optionList.add(Option.getInstance(VMNameOption.class));
        } else if (itemName.equals("baseImage")) {
            optionList.add(Option.getInstance(BaseImageOption.class));
        } else if (!itemName.equals("deviceTemplate")) {
            if (itemName.equals("display")) {
                optionList.add(Option.getInstance(DisplayOption.class));
            } else if (itemName.equals("processors")) {
                optionList.add(Option.getInstance(ProcessorOption.class));
            } else if (itemName.equals("ramSize")) {
                optionList.add(Option.getInstance(RamSizeOption.class));
            } else if (itemName.equals("suspendSupport")) {
                optionList.add(Option.getInstance(SuspendSupportOption.class));
            } else if (itemName.equals("fileShare")) {
                optionList.add(Option.getInstance(FileShareOption.class));
            } else if (itemName.equals("hwSupport")) {
                optionList.add(Option.getInstance(CPUSupportOption.class));
                optionList.add(Option.getInstance(GPUSupportOption.class));
            } else if (itemName.equals("glVersion")) {
                optionList.add(Option.getInstance(GLVersionOption.class));
            } else if (itemName.equals("netConnectType")) {
                optionList.add(Option.getInstance(NetworkOption.class));
            } else if (itemName.equals("proxy")) {
                optionList.add(Option.getInstance(NetProxyOption.class));
            } else if (itemName.equals("cameraLegacy")) {
                optionList.add(Option.getInstance(CameraLegacyOption.class));
            } else if (!itemName.equals("camera")) {
                if (itemName.equals("rearType")) {
                    optionList.add(Option.getInstance(RearCameraOption.class));
                } else if (itemName.equals("frontType")) {
                    optionList.add(Option.getInstance(FrontCameraOption.class));
                } else if (itemName.equals("sensor")) {
                    optionList.add(Option.getInstance(SensorOption.class));
                } else if (itemName.equals("connectivity")) {
                    optionList.add(Option.getInstance(ConnectivityOption.class));
                }
            }
        }
    }
}

