/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.devices;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.tizen.emulator.manager.devices.DeviceTemplate;
import org.tizen.emulator.manager.devices.DeviceTemplateUtil;
import org.tizen.emulator.manager.resources.FilePathResources;

public class CommonDeviceTemplateList {
    private static SortedSet<DeviceTemplate> templateList = null;

    public static SortedSet<DeviceTemplate> getDeviceTemplateList(boolean isRefresh) {
        if (templateList == null || isRefresh) {
            templateList = CommonDeviceTemplateList.loadTemplates();
        }
        return templateList;
    }

    public static List<DeviceTemplate> getCustomDeviceTemplateList() {
        ArrayList<DeviceTemplate> list = new ArrayList<DeviceTemplate>();
        for (DeviceTemplate template : templateList) {
            if (template.getValue().isStandard()) continue;
            list.add(template);
        }
        return list;
    }

    public static List<DeviceTemplate> getStandardDeviceTemplateList() {
        ArrayList<DeviceTemplate> list = new ArrayList<DeviceTemplate>();
        for (DeviceTemplate template : templateList) {
            if (!template.getValue().isStandard()) continue;
            list.add(template);
        }
        return list;
    }

    public static void addTemplate(DeviceTemplate template) {
        if (template != null) {
            templateList.add(template);
        }
    }

    public static void removeTemplate(DeviceTemplate template) {
        if (template != null) {
            templateList.remove(template);
        }
    }

    static synchronized SortedSet<DeviceTemplate> loadTemplates() {
        TreeSet<DeviceTemplate> deviceList = new TreeSet<DeviceTemplate>();
        DeviceTemplateUtil.loadTemplates(FilePathResources.getToolEmulatorDevicePath(), deviceList);
        DeviceTemplateUtil.loadTemplates(FilePathResources.getTizenSDKDataDevicePath(), deviceList);
        return deviceList;
    }

    static {
        templateList = CommonDeviceTemplateList.loadTemplates();
    }
}

