/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.dialog;

import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ToolBar;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.tizen.emulator.manager.ui.Main;
import org.tizen.emulator.manager.ui.dialog.ButtonBar;
import org.tizen.emulator.manager.ui.dialog.ButtonType;
import org.tizen.emulator.manager.ui.dialog.Dialog;
import org.tizen.emulator.manager.ui.dialog.DialogPane;

class InternalDialog {
    final Stage stage = new Stage(){

        public void centerOnScreen() {
            Window owner = this.getOwner();
            if (owner != null) {
                InternalDialog.this.positionStage();
            } else if (this.getWidth() > 0.0 && this.getHeight() > 0.0) {
                super.centerOnScreen();
            }
        }
    };
    private Scene scene;
    private final Parent DUMMY_ROOT = new Region();
    private final Dialog<?> dialog;
    private Pane dialogPane;
    private static final int HEADER_HEIGHT = 28;
    private double mouseDragOffsetX = 0.0;
    private double mouseDragOffsetY = 0.0;
    protected Label titleLabel;
    private double prefX = Double.NaN;
    private double prefY = Double.NaN;
    private RootPane decoratedRoot;

    public InternalDialog(Dialog<?> d) {
        this.dialog = d;
        this.stage.setResizable(false);
        this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                if (InternalDialog.this.requestPermissionToClose(InternalDialog.this.dialog)) {
                    InternalDialog.this.close();
                } else {
                    event.consume();
                }
            }
        });
        this.stage.addEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.ESCAPE && !event.isConsumed() && InternalDialog.this.requestPermissionToClose(InternalDialog.this.dialog)) {
                    InternalDialog.this.dialog.close();
                    event.consume();
                }
            }
        });
    }

    void initStyle(StageStyle style) {
        this.stage.initStyle(style);
    }

    StageStyle getStyle() {
        return this.stage.getStyle();
    }

    public void initOwner(Window newOwner) {
        this.updateStageBindings(this.stage.getOwner(), newOwner);
        this.stage.initOwner(newOwner);
    }

    public Window getOwner() {
        return this.stage.getOwner();
    }

    public void initModality(Modality modality) {
        this.stage.initModality(modality == null ? Modality.APPLICATION_MODAL : modality);
    }

    public Modality getModality() {
        return this.stage.getModality();
    }

    public void setResizable(boolean resizable) {
        this.stage.setResizable(resizable);
    }

    public void setDialogPane(DialogPane pane) {
        this.dialogPane = pane.getPane();
        if (this.getStyle() == StageStyle.DECORATED) {
            this.dialogPane.getStyleClass().addAll((Object[])new String[]{"dialog", "root"});
            this.setPane(this.dialogPane);
            this.dialogPane.autosize();
            this.stage.sizeToScene();
            return;
        }
        this.decoratedRoot = new RootPane();
        this.decoratedRoot.getChildren().add((Object)this.dialogPane);
        this.decoratedRoot.getStyleClass().addAll((Object[])new String[]{"dialog", "root"});
        this.setPane((Pane)this.decoratedRoot);
        ToolBar toolBar = this.createToolBar();
        this.titleLabel = new Label();
        this.titleLabel.getStyleClass().add((Object)"window-title");
        this.titleLabel.setText(this.dialog.getTitle());
        toolBar.getItems().add((Object)this.titleLabel);
        ((BorderPane)this.dialogPane).setTop((Node)toolBar);
        this.dialogPane.autosize();
        this.stage.sizeToScene();
        this.stage.focusedProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                InternalDialog.this.decoratedRoot.pseudoClassStateChanged("active");
            }
        });
        this.stage.titleProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable valueModel) {
                InternalDialog.this.titleLabel.setText(InternalDialog.this.dialog.getTitle());
            }
        });
    }

    private void setPane(Pane pane) {
        if (this.scene == null) {
            this.scene = new Scene((Parent)pane);
            this.stage.setScene(this.scene);
        } else {
            this.scene.setRoot((Parent)pane);
        }
        this.scene.getStylesheets().addAll(Main.getBaseCssUrl());
        this.scene.getStylesheets().add((Object)Dialog.getDialogCssUrl().toExternalForm());
        this.scene.setFill((Paint)Color.TRANSPARENT);
    }

    private ToolBar createToolBar() {
        ToolBar toolBar = new ToolBar();
        toolBar.getStyleClass().add((Object)"window-header");
        toolBar.setPrefHeight(28.0);
        toolBar.setMinHeight(28.0);
        toolBar.setMaxHeight(28.0);
        toolBar.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                InternalDialog.this.mouseDragOffsetX = event.getSceneX();
                InternalDialog.this.mouseDragOffsetY = event.getSceneY();
            }
        });
        toolBar.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                InternalDialog.this.setX(event.getScreenX() - InternalDialog.this.mouseDragOffsetX);
                InternalDialog.this.setY(event.getScreenY() - InternalDialog.this.mouseDragOffsetY);
            }
        });
        return toolBar;
    }

    public void show() {
        if (this.decoratedRoot != null) {
            this.scene.setRoot((Parent)this.decoratedRoot);
        }
        this.stage.centerOnScreen();
        this.stage.show();
    }

    public void showAndWait() {
        if (this.decoratedRoot != null) {
            this.scene.setRoot((Parent)this.decoratedRoot);
        }
        this.stage.centerOnScreen();
        this.stage.showAndWait();
    }

    public void close() {
        if (this.stage.isShowing()) {
            this.stage.hide();
        }
        if (this.scene != null) {
            this.scene.setRoot(this.DUMMY_ROOT);
        }
    }

    public ReadOnlyBooleanProperty showingProperty() {
        return this.stage.showingProperty();
    }

    public Window getWindow() {
        return this.stage;
    }

    public Node getRoot() {
        return this.stage.getScene().getRoot();
    }

    public double getX() {
        return this.stage.getX();
    }

    public void setX(double x) {
        this.stage.setX(x);
    }

    public ReadOnlyDoubleProperty xProperty() {
        return this.stage.xProperty();
    }

    public double getY() {
        return this.stage.getY();
    }

    public void setY(double y) {
        this.stage.setY(y);
    }

    public ReadOnlyDoubleProperty yProperty() {
        return this.stage.yProperty();
    }

    ReadOnlyDoubleProperty heightProperty() {
        return this.stage.heightProperty();
    }

    void setHeight(double height) {
        this.stage.setHeight(height);
    }

    double getSceneHeight() {
        return this.scene == null ? 0.0 : this.scene.getHeight();
    }

    ReadOnlyDoubleProperty widthProperty() {
        return this.stage.widthProperty();
    }

    void setWidth(double width) {
        this.stage.setWidth(width);
    }

    BooleanProperty resizableProperty() {
        return this.stage.resizableProperty();
    }

    StringProperty titleProperty() {
        return this.stage.titleProperty();
    }

    ReadOnlyBooleanProperty focusedProperty() {
        return this.stage.focusedProperty();
    }

    public void sizeToScene() {
        this.stage.sizeToScene();
    }

    public void setMinSize(double width, double height) {
        this.stage.setMinHeight(height);
        this.stage.setMinWidth(width);
    }

    private void positionStage() {
        double dialogHeight;
        double x = this.getX();
        double y = this.getY();
        if (!Double.isNaN(x) && !Double.isNaN(y) && Double.compare(x, this.prefX) != 0 && Double.compare(y, this.prefY) != 0) {
            this.setX(x);
            this.setY(y);
            return;
        }
        this.dialogPane.layout();
        Window owner = this.getOwner();
        Scene ownerScene = owner.getScene();
        double titleBarHeight = ownerScene.getY();
        double dialogWidth = this.dialogPane.prefWidth(-1.0);
        if (dialogWidth < 400.0) {
            dialogWidth = 400.0;
        }
        if ((dialogHeight = this.dialogPane.prefHeight(dialogWidth)) < 150.0) {
            dialogHeight = 150.0;
        }
        this.stage.sizeToScene();
        x = owner.getX() + ownerScene.getWidth() / 2.0 - dialogWidth / 2.0;
        y = owner.getY() + titleBarHeight / 2.0 + ownerScene.getHeight() / 2.0 - dialogHeight / 2.0;
        this.prefX = x;
        this.prefY = y;
        this.setX(x);
        this.setY(y);
    }

    private void updateStageBindings(Window oldOwner, Window newOwner) {
        Scene dialogScene = this.stage.getScene();
        if (oldOwner != null && oldOwner instanceof Stage) {
            Stage oldStage = (Stage)oldOwner;
            Bindings.unbindContent((Object)this.stage.getIcons(), (Object)oldStage.getIcons());
            Scene oldScene = oldStage.getScene();
            if (this.scene != null && dialogScene != null) {
                Bindings.unbindContent((Object)dialogScene.getStylesheets(), (Object)oldScene.getStylesheets());
            }
        }
        if (newOwner instanceof Stage) {
            Stage newStage = (Stage)newOwner;
            Bindings.bindContent((List)this.stage.getIcons(), (ObservableList)newStage.getIcons());
            Scene newScene = newStage.getScene();
            if (this.scene != null && dialogScene != null) {
                Bindings.bindContent((List)dialogScene.getStylesheets(), (ObservableList)newScene.getStylesheets());
            }
        }
    }

    public boolean requestPermissionToClose(Dialog<?> dialog) {
        boolean denyClose = true;
        DialogPane dialogPane = dialog.getDialogPane();
        if (dialogPane != null) {
            ObservableList<ButtonType> buttons = dialogPane.getButtonTypes();
            if (buttons.size() == 1) {
                denyClose = false;
            } else {
                for (ButtonType button : buttons) {
                    ButtonBar.ButtonData type;
                    if (button == null || (type = button.getButtonData()) == null || type != ButtonBar.ButtonData.CANCEL_CLOSE && !type.isCancelButton()) continue;
                    denyClose = false;
                    break;
                }
            }
        }
        return !denyClose;
    }

    private static class RootPane
    extends StackPane {
        private RootPane() {
        }

        private void pseudoClassStateChanged(String pseudoClass) {
            if (this.getScene().getWindow().isFocused()) {
                this.getStyleClass().remove((Object)"root");
                this.getStyleClass().add((Object)"active");
            } else {
                this.getStyleClass().add((Object)"root");
                this.getStyleClass().remove((Object)"active");
            }
        }
    }
}

