/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.platform;

import java.util.ArrayList;
import java.util.List;
import org.tizen.emulator.manager.platform.Skin;
import org.tizen.emulator.manager.vms.type.RESOLUTION;
import org.tizen.emulator.manager.vms.type.SKIN_SHAPE;
import org.tizen.emulator.manager.vms.type.SKIN_TYPE;

public class SkinList {
    private static List<Skin> returnSkins = new ArrayList<Skin>();

    public static Skin findSkinByPath(String path, List<Skin> list) {
        if (list != null) {
            for (Skin skin : list) {
                if (!skin.getPath().equals(path)) continue;
                return skin;
            }
        }
        return null;
    }

    public static Skin findSkinByName(String name, List<Skin> list) {
        if (list != null) {
            for (Skin skin : list) {
                if (!skin.getName().equals(name)) continue;
                return skin;
            }
        }
        return null;
    }

    public static List<Skin> findSkinList(RESOLUTION resolution, List<Skin> list) {
        returnSkins.clear();
        if (list != null) {
            for (Skin skin : list) {
                if (skin.getType() == SKIN_TYPE.GENERAL) {
                    returnSkins.add(skin);
                    continue;
                }
                if (!skin.getResolution().equals(resolution)) continue;
                returnSkins.add(skin);
            }
        }
        return SkinList.sortForPriority(returnSkins);
    }

    public static List<Skin> findSkinList(RESOLUTION resolution, SKIN_SHAPE skinShape, List<Skin> list) {
        returnSkins.clear();
        if (list != null) {
            for (Skin skin : list) {
                if (skin.getType() != SKIN_TYPE.GENERAL && !skin.getResolution().equals(resolution) || skinShape != SKIN_SHAPE.NONE && !skin.getSkinShapeList().hasShape(skinShape)) continue;
                returnSkins.add(skin);
            }
        }
        return SkinList.sortForPriority(returnSkins);
    }

    public static List<Skin> findGeneralSkinList(List<Skin> list) {
        returnSkins.clear();
        if (list != null) {
            for (Skin skin : list) {
                if (skin.getType() != SKIN_TYPE.GENERAL) continue;
                returnSkins.add(skin);
            }
        }
        return SkinList.sortForPriority(returnSkins);
    }

    public static List<Skin> sortForPriority(List<Skin> list) {
        ArrayList<Skin> tempList = new ArrayList<Skin>();
        for (Skin s : list) {
            tempList.add(s);
            for (int j = tempList.size() - 1; j > 0 && ((Skin)tempList.get(j - 1)).getPriorty() > ((Skin)tempList.get(j)).getPriorty(); --j) {
                Skin t = (Skin)tempList.get(j - 1);
                tempList.set(j - 1, (Skin)tempList.get(j));
                tempList.set(j, t);
            }
        }
        return tempList;
    }
}

