/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.resources;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.tizen.emulator.manager.EmulatorManager;
import org.tizen.emulator.manager.logging.EMLogger;

class InternalFindSDKPath {
    private static final String SDKINFO_SUFFIX = File.separator + "sdk.info";
    private String sdkDataPath;
    private String sdkPath;

    InternalFindSDKPath() {
    }

    String getSDKDataPath() {
        return this.sdkDataPath;
    }

    String getSDKPath() {
        return this.sdkPath;
    }

    private String getCurrentPath() {
        URL url = EmulatorManager.class.getProtectionDomain().getCodeSource().getLocation();
        File jar = null;
        try {
            jar = new File(url.toURI().getPath());
        }
        catch (URISyntaxException e) {
            EMLogger.getLogger().warning(e.getMessage());
        }
        if (jar != null) {
            return jar.getParent();
        }
        File path = new File(url.getFile());
        if (path != null) {
            return path.getParent();
        }
        return null;
    }

    void findSDKPath(String sdkDir) throws IOException {
        Path sdkInfoPath = Paths.get(sdkDir + File.separator + SDKINFO_SUFFIX, new String[0]);
        if (sdkDir == null) {
            String currentPath = this.getCurrentPath();
            if (currentPath == null) {
                throw new IOException("Failed to get em-lib.jar path");
            }
            sdkInfoPath = Paths.get(currentPath + File.separator + SDKINFO_SUFFIX, new String[0]);
            Path dir = Paths.get(currentPath, new String[0]);
            while (!Files.exists(sdkInfoPath, new LinkOption[0])) {
                if ((dir = dir.getParent()) == null) {
                    throw new IOException("Failed to find sdk.info file");
                }
                sdkInfoPath = Paths.get(dir.toString() + File.separator + SDKINFO_SUFFIX, new String[0]);
            }
        }
        try {
            sdkInfoPath = sdkInfoPath.toRealPath(LinkOption.NOFOLLOW_LINKS);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        String dataPath = null;
        EMLogger.log("sdk.info file path: " + sdkInfoPath);
        try (BufferedReader in = Files.newBufferedReader(sdkInfoPath, Charset.forName("UTF-8"));){
            String s = null;
            while ((s = in.readLine()) != null) {
                int i = s.indexOf("=");
                if (i == -1) continue;
                String s1 = s.substring(0, i);
                String s2 = s.substring(i + 1, s.length());
                if (s1.equals("TIZEN_SDK_INSTALLED_PATH")) {
                    this.sdkPath = s2;
                    EMLogger.log("TIZEN_SDK_INSTALLED_PATH: " + this.sdkPath);
                    continue;
                }
                if (!s1.equals("TIZEN_SDK_DATA_PATH")) continue;
                this.sdkDataPath = s2;
                EMLogger.log("TIZEN_SDK_DATA_PATH: " + dataPath);
            }
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            EMLogger.getLogger().warning("Failed to open sdk.info file : " + e.getMessage());
        }
        catch (IOException e) {
            EMLogger.log(e.getMessage());
        }
    }
}

