/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class VMOption
implements Cloneable {
    private String name = "";
    private String value = null;
    protected Object data = null;
    private final List<VMOption> subOptionList = new ArrayList<VMOption>();
    private static final Comparator<VMOption> comparator = new Comparator<VMOption>(){

        @Override
        public int compare(VMOption o1, VMOption o2) {
            return o1.name.compareTo(o2.name);
        }
    };

    public VMOption(String name) {
        this(name, null);
    }

    public VMOption(String name, String value) {
        assert (name != null);
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public List<VMOption> getSubOptionList() {
        return this.subOptionList;
    }

    public VMOption getSubOption(String subName) {
        for (VMOption option : this.subOptionList) {
            if (!option.getName().equals(subName)) continue;
            return option;
        }
        return null;
    }

    public void addSubOption(VMOption subOption) {
        if (subOption == null) {
            return;
        }
        this.subOptionList.add(subOption);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VMOption)) {
            return false;
        }
        VMOption dest = (VMOption)obj;
        if (!this.name.equals(dest.getName())) {
            return false;
        }
        if (this.value == null && dest.getValue() != null) {
            return false;
        }
        if (this.value != null) {
            if (dest.getValue() == null) {
                return false;
            }
            if (!this.value.equals(dest.getValue())) {
                return false;
            }
        }
        if (this.data == null && dest.getData() != null) {
            return false;
        }
        if (this.data != null) {
            if (dest.getData() == null) {
                return false;
            }
            if (!this.data.equals(dest.getData())) {
                return false;
            }
        }
        return VMOption.isOptionListEquals(this.subOptionList, dest.subOptionList);
    }

    static boolean isOptionListEquals(List<VMOption> list1, List<VMOption> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        if (list1.isEmpty() && list2.isEmpty()) {
            return true;
        }
        ArrayList<VMOption> sortedList1 = new ArrayList<VMOption>(list1);
        ArrayList<VMOption> sortedList2 = new ArrayList<VMOption>(list2);
        sortedList1.sort(comparator);
        sortedList2.sort(comparator);
        for (int i = 0; i < list1.size(); ++i) {
            if (((VMOption)sortedList1.get(i)).equals(sortedList2.get(i))) continue;
            return false;
        }
        return true;
    }

    public VMOption clone() {
        VMOption option = new VMOption(this.name);
        option.setValue(this.value);
        option.setData(this.data);
        for (VMOption srcSub : this.getSubOptionList()) {
            VMOption subOption = srcSub.clone();
            option.addSubOption(subOption);
        }
        return option;
    }
}

