/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.monitor;

import java.util.logging.Level;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.monitor.MonitoringThread;

public final class LaunchingMonitor
implements Runnable {
    private final VMProperty property;
    private final Process process;
    private int timeoutSec;
    private int exitValue = -1;

    public LaunchingMonitor(VMProperty property, Process process) {
        assert (property != null);
        assert (process != null);
        this.property = property;
        this.process = process;
    }

    private boolean executeInternal() {
        Thread waitingThread = MonitoringThread.newMonitoringThread(new Runnable(){

            @Override
            public void run() {
                try {
                    LaunchingMonitor.this.exitValue = LaunchingMonitor.this.process.waitFor();
                }
                catch (InterruptedException e) {
                    EMLogger.getLogger().log(Level.FINE, e.getMessage());
                }
            }
        }, "Waiting VM process " + this.property.getPropertyValue().vmName);
        waitingThread.start();
        try {
            waitingThread.join(1000 * this.timeoutSec);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.exitValue == -1) {
            waitingThread.interrupt();
            return true;
        }
        if (this.exitValue == 0) {
            EMLogger.getLogger().warning(String.format("Emulator has been terminated in " + this.timeoutSec + "seconds.", new Object[0]));
            return true;
        }
        EMLogger.getLogger().warning("You can see more information in the emulator-manager.log or " + this.property.getPropertyValue().vmName + "'s logs directory.");
        return false;
    }

    public boolean execute() {
        this.timeoutSec = 8;
        return this.executeInternal();
    }

    public void asyncExecute() {
        this.timeoutSec = 8;
        MonitoringThread.newMonitoringThread(this, "LaunchingMonitor").start();
    }

    @Override
    public void run() {
        this.property.setState(VMProperty.State.LAUNCHING);
        if (this.executeInternal()) {
            if (this.property.getState() != VMProperty.State.RUNNING) {
                EMLogger.getLogger().warning("Emulator is launched successfully, but it is not detected by RunningMonitor. Please Check about it.");
                this.property.setState(VMProperty.State.READY);
                assert (false);
            }
        } else {
            this.property.setState(VMProperty.State.READY);
        }
    }
}

