/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.option;

import java.util.ArrayList;
import java.util.List;

public class QemuOptions {
    private final List<Item> list = new ArrayList<Item>();

    public void add(String option) {
        if (option.startsWith("#")) {
            this.list.add(new Item(option));
        } else {
            String[] optionSplit = option.split("\\s+", 2);
            if (optionSplit.length == 1) {
                this.list.add(new Item(option));
            } else if (optionSplit.length == 2) {
                this.add(optionSplit[0], optionSplit[1]);
            }
        }
    }

    public void add(String name, String option) {
        String[] optionSplit = option.split("\\s{0,},\\s{0,}", 2);
        if (optionSplit.length == 1) {
            this.list.add(new Item(name, optionSplit[0]));
        } else if (optionSplit.length == 2) {
            this.add(name, optionSplit[0], optionSplit[1], false);
        }
    }

    public void add(String name, String value, String options) {
        this.add(name, value, options, false);
    }

    public void add(String name, String value, String options, boolean isAppendOptions) {
        String[] optionSplit;
        Item item = null;
        if (isAppendOptions) {
            item = this.findItem(name, value);
        }
        if (item == null) {
            item = new Item(name, value);
            this.list.add(item);
        }
        for (String opt : optionSplit = options.split("\\s{0,},\\s{0,}")) {
            item.addOption(opt);
        }
    }

    public List<String> getContents() {
        ArrayList<String> contents = new ArrayList<String>();
        for (Item item : this.list) {
            contents.add(item.getArgument());
        }
        return contents;
    }

    private Item findItem(String name, String value) {
        for (Item item : this.list) {
            if (!item.getName().equals(name) || !item.getValue().equals(value)) continue;
            return item;
        }
        return null;
    }

    class Item {
        private final String name;
        private String value;
        private List<String> options;

        public Item(String name) {
            this.name = name;
        }

        public Item(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public void addOption(String option) {
            if (this.options == null) {
                this.options = new ArrayList<String>();
            }
            this.options.add(option);
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String getArgument() {
            StringBuilder sb = new StringBuilder();
            if (this.name != null && !this.name.isEmpty()) {
                sb.append(this.name);
            }
            if (this.value != null && !this.value.isEmpty()) {
                sb.append(" ").append(this.value);
            }
            if (this.options != null) {
                for (String opt : this.options) {
                    sb.append(",").append(opt);
                }
            }
            return sb.toString();
        }

        public String toString() {
            return this.getArgument();
        }
    }
}

