/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.item;

import java.util.ArrayList;
import java.util.List;
import org.tizen.emulator.manager.ui.item.CommonViewItemFactoryV3;
import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.ui.template.Template;
import org.tizen.emulator.manager.ui.template.item.Group;
import org.tizen.emulator.manager.ui.template.item.Item;

public class CommonViewItemFactoryV2
extends CommonViewItemFactoryV3 {
    private Group getDefaultItemGroup(Template template) {
        for (Group group : template.getGroupItems()) {
            if (!group.getName().equals("default")) continue;
            return group;
        }
        return null;
    }

    private Group getAdvancedItemGroup(Template template) {
        for (Group group : template.getGroupItems()) {
            if (!group.getName().equals("advanced")) continue;
            return group;
        }
        return null;
    }

    private List<Item> getDetailTabList(Template template) {
        ArrayList<Item> itemList = new ArrayList<Item>();
        Item general = new Item();
        general.setName("general");
        Group defaultItemGroup = this.getDefaultItemGroup(template);
        Group advancedItemGroup = this.getAdvancedItemGroup(template);
        if (defaultItemGroup != null) {
            for (Item item : defaultItemGroup.getItems()) {
                if (item.getName().equals("deviceTemplate")) {
                    Item temp = new Item();
                    temp.setName("deviceTemplate");
                    temp.setTitle("Template");
                    temp.setType("label");
                    general.addSubItem(temp);
                    for (Item i : item.getSubItems()) {
                        if (i.getName().equals("display")) {
                            Item path = new Item();
                            path.setName("skinPath");
                            path.setTitle("Skin Path");
                            i.addSubItem(path);
                        }
                        general.addSubItem(i);
                    }
                    continue;
                }
                if (item.getName().equals("baseImage")) {
                    item.setTitle("Platform");
                    general.addSubItem(item);
                    continue;
                }
                general.addSubItem(item);
            }
        }
        if (advancedItemGroup != null) {
            for (Item item : advancedItemGroup.getItems()) {
                if (item.isExperimental() || !item.isSupportOS()) continue;
                general.addSubItem(item);
            }
        }
        itemList.add(general);
        return itemList;
    }

    @Override
    public List<Item> getTabList(Template template) {
        if (this.getMode() == MODE.DETAIL) {
            return this.getDetailTabList(template);
        }
        ArrayList<Item> tabList = new ArrayList<Item>();
        Item base = new Item();
        base.setName("general");
        base.setTitle("General");
        tabList.add(base);
        Item ramSizeItem = null;
        Item processorItem = null;
        Item templateItem = null;
        Group defaultItemGroup = this.getDefaultItemGroup(template);
        Group advancedItemGroup = this.getAdvancedItemGroup(template);
        if (defaultItemGroup != null) {
            for (Item item : defaultItemGroup.getItems()) {
                if (item.getName().equals("deviceTemplate")) {
                    templateItem = item.clone();
                    tabList.add(templateItem);
                    Item device = new Item();
                    if (this.getMode() == MODE.MODIFY) {
                        device.setName("deviceTemplate");
                        device.setTitle("Template");
                        device.setType("combo");
                    } else {
                        device.setName("template-name");
                        device.setTitle("Template");
                        device.setType("label");
                    }
                    templateItem.getSubItems().add(0, device);
                    for (Item subItem : templateItem.getSubItems()) {
                        if (subItem.getName().equals("ramSize")) {
                            ramSizeItem = subItem;
                            continue;
                        }
                        if (subItem.getName().equals("processors")) {
                            processorItem = subItem;
                            continue;
                        }
                        if (!subItem.getName().equals("display")) continue;
                        if (this.getMode() == MODE.MODIFY) {
                            subItem.setName("template-display");
                            subItem.setTitle("Display");
                            subItem.setType("label");
                            continue;
                        }
                        subItem.setSupportOS(false);
                    }
                    continue;
                }
                base.getSubItems().add(item);
            }
        }
        if (templateItem != null) {
            templateItem.getSubItems().remove(ramSizeItem);
            templateItem.getSubItems().remove(processorItem);
        }
        Item temp = new Item();
        temp.setName("template-name");
        temp.setTitle("Template");
        temp.setType("label");
        Item display = new Item();
        display.setName("display");
        display.setTitle("Display");
        display.setType("label");
        base.addSubItem(temp);
        base.addSubItem(display);
        if (processorItem != null) {
            base.addSubItem(processorItem);
        }
        if (ramSizeItem != null) {
            base.addSubItem(ramSizeItem);
        }
        if (advancedItemGroup != null) {
            for (Item item : advancedItemGroup.getItems()) {
                if (item.isExperimental() || !item.isSupportOS()) continue;
                if (!item.getType().equals("label")) {
                    base.addSubItem(item);
                    continue;
                }
                tabList.add(item);
            }
        }
        return tabList;
    }
}

